/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.modelling.arima.AICcComparator;
import ec.tstoolkit.modelling.arima.IModelComparator;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModelBuilder;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.RegArimaEstimator;
import ec.tstoolkit.modelling.arima.x13.X13Preprocessor;
import ec.tstoolkit.sarima.SarimaModel;

public class EasterDetection
implements IPreprocessingModule {
    private IModelComparator comparer_;
    private int[] duration_ = new int[]{1, 8, 15};
    private double eps_ = 1.0E-5;
    private static final String EASTER_LENGTH = "EASTER test";

    public double getEpsilon() {
        return this.eps_;
    }

    public void setEpsilon(double val) {
        this.eps_ = val;
    }

    public int[] getDurations() {
        return this.duration_;
    }

    public void setDurations(int[] duration) {
        this.duration_ = duration;
    }

    public void setDuration(int duration) {
        this.duration_ = new int[]{duration};
    }

    public EasterDetection() {
        this.comparer_ = new AICcComparator();
    }

    public EasterDetection(IModelComparator cmp) {
        this.comparer_ = cmp;
    }

    private void addInfo(ModelEstimation[] emodels, InformationSet information, boolean easter) {
    }

    public void clear() {
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        this.clear();
        this.addStartInfo(context);
        IParametricMapping<SarimaModel> mapping = X13Preprocessor.createDefaultMapping(context.description);
        RegArimaEstimator monitor = new RegArimaEstimator(mapping);
        monitor.setPrecision(this.eps_);
        int n = this.duration_.length;
        int icur = -1;
        ModelEstimation[] emodels = new ModelEstimation[n];
        ModelDescription[] desc = new ModelDescription[n];
        int nhp = mapping.getDim();
        if (context.estimation == null) {
            context.estimation = new ModelEstimation(context.description.buildRegArima(), context.description.getLikelihoodCorrection());
            context.estimation.compute(monitor, nhp);
        }
        ModelDescription refdesc = context.description.clone();
        ModelEstimation refest = null;
        if (!PreprocessingModelBuilder.updateEaster(refdesc, 0)) {
            refest = context.estimation;
        } else {
            refest = new ModelEstimation(refdesc.buildRegArima(), refdesc.getLikelihoodCorrection());
            refest.compute(monitor, nhp);
        }
        for (int i = 0; i < n; ++i) {
            desc[i] = context.description.clone();
            if (!PreprocessingModelBuilder.updateEaster(desc[i], this.duration_[i])) {
                icur = i;
                emodels[i] = context.estimation;
                continue;
            }
            try {
                emodels[i] = new ModelEstimation(desc[i].buildRegArima(), desc[i].getLikelihoodCorrection());
                emodels[i].compute(monitor, nhp);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int imodel = this.comparer_.compare(refest, emodels);
        if (imodel < 0) {
            context.description = refdesc;
            context.estimation = refest;
        } else {
            context.description = desc[imodel];
            context.estimation = emodels[imodel];
        }
        this.addInfo(emodels, context.information, imodel >= 0);
        this.addEndInfo(emodels, context, imodel);
        return icur == imodel ? ProcessingResult.Unchanged : ProcessingResult.Changed;
    }

    private void addStartInfo(ModellingContext context) {
    }

    private void addEndInfo(ModelEstimation[] models, ModellingContext context, int sel) {
    }
}

