/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.information.InformationSet;
import java.util.ArrayList;
import java.util.List;

public abstract class ProcessingManager {
    private static ProcessingManager instance_;

    public static synchronized ProcessingManager getInstance() {
        if (instance_ == null) {
            instance_ = new DefaultProcessingManager();
        }
        return instance_;
    }

    public abstract <S extends IProcSpecification, I, R extends IProcResults> void register(IProcessingFactory<S, I, R> var1, Class<S> var2);

    public abstract List<IProcessingFactory<?, ?, ?>> processors();

    public abstract IProcessing<?, ?> createProcessor(InformationSet var1, ProcessingContext var2);

    public abstract IProcSpecification createSpecification(InformationSet var1);

    public abstract <S extends IProcSpecification> IProcessing<?, ?> createProcessor(S var1, ProcessingContext var2);

    public abstract List<Class<? extends IProcSpecification>> specifications(IProcessingFactory var1);

    static class DefaultProcessingManager
    extends ProcessingManager {
        private ArrayList<Item<? extends IProcSpecification>> items_ = new ArrayList();

        DefaultProcessingManager() {
        }

        @Override
        public <S extends IProcSpecification, I, R extends IProcResults> void register(IProcessingFactory<S, I, R> factory, Class<S> sclass) {
            this.items_.add(new Item<S>(factory, sclass));
        }

        @Override
        public IProcessing<?, ?> createProcessor(InformationSet info, ProcessingContext context) {
            AlgorithmDescriptor desc = info.get("algorithm", AlgorithmDescriptor.class);
            if (desc == null) {
                return null;
            }
            for (Item<? extends IProcSpecification> item : this.items_) {
                if (!item.factory.getInformation().isCompatible(desc)) continue;
                try {
                    IProcSpecification spec = (IProcSpecification)item.sclass.newInstance();
                    if (!spec.read(info)) {
                        return null;
                    }
                    return item.factory.generateProcessing(spec, context);
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public <S extends IProcSpecification> IProcessing<?, ?> createProcessor(S spec, ProcessingContext context) {
            for (Item<? extends IProcSpecification> item : this.items_) {
                if (!item.factory.canHandle(spec)) continue;
                return item.factory.generateProcessing(spec, context);
            }
            return null;
        }

        @Override
        public IProcSpecification createSpecification(InformationSet info) {
            AlgorithmDescriptor desc = info.get("algorithm", AlgorithmDescriptor.class);
            if (desc == null) {
                return null;
            }
            for (Item<? extends IProcSpecification> item : this.items_) {
                if (!item.factory.getInformation().isCompatible(desc)) continue;
                try {
                    IProcSpecification spec = (IProcSpecification)item.sclass.newInstance();
                    if (!spec.read(info)) {
                        return null;
                    }
                    return spec;
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public List<IProcessingFactory<?, ?, ?>> processors() {
            ArrayList p = new ArrayList();
            for (Item<? extends IProcSpecification> item : this.items_) {
                p.add(item.factory);
            }
            return p;
        }

        @Override
        public List<Class<? extends IProcSpecification>> specifications(IProcessingFactory factory) {
            ArrayList<Class<? extends IProcSpecification>> specs = new ArrayList<Class<? extends IProcSpecification>>();
            for (Item<? extends IProcSpecification> cur : this.items_) {
                if (cur.factory != factory) continue;
                specs.add(cur.sclass);
            }
            return specs;
        }

        static class Item<S extends IProcSpecification> {
            final IProcessingFactory factory;
            final Class<S> sclass;

            Item(IProcessingFactory<S, ?, ?> factory, Class<S> sclass) {
                this.factory = factory;
                this.sclass = sclass;
            }
        }
    }
}

