/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.random;

import ec.tstoolkit.random.IRandomNumberGenerator;

public final class StochasticRandomizer {
    private StochasticRandomizer() {
    }

    public static double chi2(IRandomNumberGenerator rng, int degreesoffreedom) {
        double r = 0.0;
        for (int i = 0; i < degreesoffreedom; ++i) {
            double n = StochasticRandomizer.normal(rng);
            r += n * n;
        }
        return r;
    }

    public static double F(IRandomNumberGenerator rng, int dfnum, int dfdenom) {
        return StochasticRandomizer.chi2(rng, dfnum) / (double)dfnum / (StochasticRandomizer.chi2(rng, dfdenom) / (double)dfdenom);
    }

    public static double normal(IRandomNumberGenerator rng) {
        double x2;
        double x1;
        double w;
        while ((w = (x1 = 2.0 * rng.nextDouble() - 1.0) * x1 + (x2 = 2.0 * rng.nextDouble() - 1.0) * x2) >= 1.0 || w < 1.0E-30) {
        }
        w = Math.sqrt(-2.0 * Math.log(w) / w);
        return x1 *= w;
    }

    public static double normal(IRandomNumberGenerator rng, double mean, double stdev) {
        return StochasticRandomizer.normal(rng) * stdev + mean;
    }

    public static double T(IRandomNumberGenerator rng, int degreesoffreedom) {
        return StochasticRandomizer.normal(rng) / Math.sqrt(StochasticRandomizer.chi2(rng, degreesoffreedom) / (double)degreesoffreedom);
    }

    public static double uniform(IRandomNumberGenerator rng, double a, double b) {
        return a + rng.nextDouble() * (b - a);
    }
}

