/*
 * Decompiled with CFR 0.152.
 */
package it.bankitalia.reri.sia.sdmx.parser.v20;

import it.bankitalia.reri.sia.sdmx.api.Dataflow;
import it.bankitalia.reri.sia.util.LocalizedText;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class DataflowParser {
    private static final String DATAFLOW = "Dataflow";
    private static final String ID = "id";
    private static final String AGENCY = "agencyID";
    private static final String VERSION = "version";
    private static final String NAME = "Name";
    private static final String KF_REF = "KeyFamilyRef";
    private static final String KF_ID = "KeyFamilyID";
    private static final String KF_AGID = "KeyFamilyAgencyID";
    private static final String KF_VER = "Version";

    public static List<Dataflow> parse(String string) throws XMLStreamException, UnsupportedEncodingException {
        ArrayList<Dataflow> arrayList = new ArrayList<Dataflow>();
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        XMLEventReader xMLEventReader = xMLInputFactory.createXMLEventReader(byteArrayInputStream);
        Dataflow dataflow = null;
        LocalizedText localizedText = new LocalizedText();
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            if (xMLEvent2.isStartElement()) {
                xMLEvent = xMLEvent2.asStartElement();
                if (xMLEvent.getName().getLocalPart() == DATAFLOW) {
                    dataflow = new Dataflow();
                    Iterator<Attribute> iterator = xMLEvent.getAttributes();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        String string2 = null;
                        String string3 = null;
                        String string4 = null;
                        if (attribute.getName().toString().equals(ID)) {
                            string2 = attribute.getValue();
                            dataflow.setId(string2);
                            continue;
                        }
                        if (attribute.getName().toString().equals(AGENCY)) {
                            string3 = attribute.getValue();
                            dataflow.setAgency(string3);
                            continue;
                        }
                        if (!attribute.getName().toString().equals(VERSION)) continue;
                        string4 = attribute.getValue();
                        dataflow.setVersion(string4);
                    }
                } else if (xMLEvent.getName().getLocalPart() == NAME) {
                    localizedText.setText((StartElement)xMLEvent, xMLEventReader);
                } else if (xMLEvent.getName().getLocalPart() == KF_REF) {
                    DataflowParser.setKeyFamily(dataflow, xMLEventReader);
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != DATAFLOW) continue;
            dataflow.setName(localizedText.getText());
            arrayList.add(dataflow);
        }
        return arrayList;
    }

    private static void setKeyFamily(Dataflow dataflow, XMLEventReader xMLEventReader) throws XMLStreamException {
        String string = null;
        String string2 = null;
        String string3 = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            if (xMLEvent2.isStartElement()) {
                xMLEvent = xMLEvent2.asStartElement();
                if (xMLEvent.getName().getLocalPart().equalsIgnoreCase(KF_ID)) {
                    string = xMLEventReader.getElementText();
                    dataflow.setDsd(string);
                } else if (xMLEvent.getName().getLocalPart().equalsIgnoreCase(KF_AGID)) {
                    string2 = xMLEventReader.getElementText();
                    dataflow.setDsdAgency(string2);
                } else if (xMLEvent.getName().getLocalPart().equalsIgnoreCase(KF_VER)) {
                    string3 = xMLEventReader.getElementText();
                    dataflow.setDsdVersion(string3);
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != KF_REF) continue;
            break;
        }
    }
}

