/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;

public class ProgressViewer
extends JDialog {
    private static final long serialVersionUID = -7937931709790747236L;
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    private final JProgressBar progressBar;
    private final SwingWorker<Void, Void> worker;
    private final AtomicBoolean interrupted = new AtomicBoolean(false);
    private Future<?> task = null;

    public ProgressViewer(Component component, final Runnable runnable) {
        this.worker = new SwingWorker<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void doInBackground() throws Exception {
                try {
                    while (!ProgressViewer.this.isVisible() && !ProgressViewer.this.interrupted.get()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!ProgressViewer.this.interrupted.get()) {
                        ProgressViewer.this.task = executorService.submit(runnable);
                        ProgressViewer.this.task.get();
                    }
                }
                finally {
                    ProgressViewer.this.setVisible(false);
                    ProgressViewer.this.dispose();
                }
                return null;
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel.setLayout(new BorderLayout(0, 0));
        this.progressBar = new JProgressBar();
        jPanel.add(this.progressBar);
        this.progressBar.setIndeterminate(true);
        Box box = Box.createHorizontalBox();
        box.setBorder(new EmptyBorder(10, 0, 0, 0));
        jPanel.add((Component)box, "South");
        Component component2 = Box.createHorizontalGlue();
        box.add(component2);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                while (ProgressViewer.this.task == null && !ProgressViewer.this.interrupted.get()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (ProgressViewer.this.task != null && !ProgressViewer.this.interrupted.get()) {
                    ProgressViewer.this.task.cancel(true);
                    ProgressViewer.this.interrupted.set(true);
                }
            }
        };
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(actionListener);
        box.add(jButton);
        this.setDefaultCloseOperation(2);
        this.setSize(300, 103);
        this.setLocationRelativeTo(component);
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("Executing query...");
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setDefaultButton(jButton);
        jRootPane.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.worker.execute();
    }
}

