/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;

public class ProgressViewer<T>
implements Serializable {
    private static final long serialVersionUID = -7937931709790747236L;
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();
    private final SwingWorker<Void, Void> worker;
    private final JDialog dialog = new JDialog();

    public ProgressViewer(Component component, Callable<T> callable, Consumer<T> consumer, Consumer<Throwable> consumer2) {
        this(component, new AtomicBoolean(false), callable, consumer, consumer2);
    }

    public ProgressViewer(Component component, final AtomicBoolean atomicBoolean, Callable<T> callable, final Consumer<T> consumer, final Consumer<Throwable> consumer2) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.dialog.getContentPane().add((Component)jPanel, "Center");
        jPanel.setLayout(new BorderLayout(0, 0));
        JProgressBar jProgressBar = new JProgressBar();
        jPanel.add(jProgressBar);
        jProgressBar.setIndeterminate(true);
        Box box = Box.createHorizontalBox();
        box.setBorder(new EmptyBorder(10, 0, 0, 0));
        jPanel.add((Component)box, "South");
        JButton jButton = new JButton("Cancel");
        box.add(Box.createHorizontalGlue());
        box.add(jButton);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setSize(300, 103);
        this.dialog.setLocationRelativeTo(component);
        this.dialog.setModal(true);
        this.dialog.setResizable(false);
        this.dialog.setTitle("Executing query...");
        final Future<Object> future = EXECUTOR_SERVICE.submit(() -> callable.call());
        ActionListener actionListener = actionEvent -> {
            future.cancel(true);
            atomicBoolean.set(true);
        };
        jButton.addActionListener(actionListener);
        this.dialog.getRootPane().setDefaultButton(jButton);
        this.dialog.getRootPane().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    while (future == null || !atomicBoolean.get() && !future.isDone()) {
                        Thread.sleep(100L);
                    }
                    Object v = future.get();
                    SwingUtilities.invokeLater(() -> ProgressViewer.this.dialog.dispose());
                    if (!atomicBoolean.get()) {
                        SwingUtilities.invokeLater(() -> consumer.accept(v));
                    }
                    return null;
                }
                catch (InterruptedException | ExecutionException exception) {
                    Throwable throwable = exception instanceof ExecutionException ? exception.getCause() : exception;
                    atomicBoolean.set(true);
                    SwingUtilities.invokeLater(() -> ProgressViewer.this.dialog.dispose());
                    SwingUtilities.invokeLater(() -> consumer2.accept(throwable));
                    return null;
                }
            }
        };
    }

    public void start() {
        this.worker.execute();
        this.dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.setVisible(true);
    }
}

