% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ReadDataFile.R
\name{ReadDataFile}
\alias{ReadDataFile}
\title{Reads the data file and creates a dataset object}
\usage{
ReadDataFile(fileName, format = "JAFROC", delimiter = ",")
}
\arguments{
\item{fileName}{A string specifying the name of the file that contains the dataset.
The extension of the file must match the corresponding format specified below.}

\item{format}{A string specifying the format of the data file. It can be \code{JAFROC} (the default), \code{MRMC} or \code{iMRMC}.
For \code{MRMC} the format is determined by the extension of the data file as specified in \url{http://perception.radiology.uiowa.edu/}:
the file extension can be .csv or .txt or .lrc. For file extension .imrmc the format is described in \url{https://code.google.com/p/imrmc/}.}

\item{delimiter}{The string delimiter to be used for the MRMC format ("," is the default), see \url{http://perception.radiology.uiowa.edu/}.
This parameter is not used when reading \code{JAFROC} or \code{iMRMC} data files.}
}
\value{
A dataset with the specified structure, see \link{RJafroc-package}.
}
\description{
Reads the dataset file to be analyzed and creates a dataset object for subsequent analysis.
}
\examples{
fullName <- "http://www.devchakraborty.com/RocData/rocData.xlsx"
download.file(url = fullName, basename(fullName), mode = "wb")
RocDataXlsx<- ReadDataFile(basename(fullName))

\dontrun{
fullName <- "http://www.devchakraborty.com/RocData/rocData.csv"
download.file(url = fullName, basename(fullName))
RocDataCsv<- ReadDataFile(basename(fullName), format = "MRMC")

fullName <- "http://www.devchakraborty.com/RocData/rocData.imrmc"
download.file(url = fullName, basename(fullName))
RocDataImrmc<- ReadDataFile(basename(fullName), format = "iMRMC")

fullName <- "http://www.devchakraborty.com/FrocData/frocData.xlsx"
download.file(url = fullName, basename(fullName), mode = "wb")
FrocDataXlsx <- ReadDataFile(basename(fullName))

fullName <- "http://www.devchakraborty.com/RoiData/roiData.xlsx"
download.file(url = fullName, basename(fullName), mode = "wb")
RoiDataXlsx <- ReadDataFile(basename(fullName))
}
}

