% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SampleSizeGivenJ.R
\name{SampleSizeGivenJ}
\alias{SampleSizeGivenJ}
\title{Calculate number of cases for specified number of readers J to achieve the desired power for ROC studies.}
\usage{
SampleSizeGivenJ(J, varYTR, varYTC, varYEps, cov1, cov2, cov3, varEps, msTR,
  KStar, alpha = 0.05, effectSize = 0.05, desiredPower = 0.8,
  randomOption = "ALL")
}
\arguments{
\item{J}{The number of readers.}

\item{varYTR}{The DBM pseudovalue treatment-by-reader variance component.}

\item{varYTC}{The DBM pseudovalue treatment-by-case variance component.}

\item{varYEps}{The DBM pseudovalue error variance.}

\item{cov1}{The covariance of the FOM resampling estimates for same reader and different modalities.}

\item{cov2}{The covariance of the FOM resampling estimates for different readers and same modalities.}

\item{cov3}{The covariance of the FOM resampling estimates for different readers and different modalities.}

\item{varEps}{The variance of the FOM resampling estimates for same reader and same modalities.}

\item{msTR}{Treatment-by-reader mean square of the FOM.}

\item{KStar}{The number of cases in the pilot study, only required when using OR variability parameters}

\item{alpha}{The significance level of the study, default value is 0.05.}

\item{effectSize}{The effect size to be used in the study, default value is 0.05.}

\item{desiredPower}{The desired statistical power, default value is 0.8.}

\item{randomOption}{It can be \code{"ALL"}, \code{"READERS"} or \code{"CASES"}, which indicate predictions for (1) random readers and random cases, (2) random readers only and
(3) random cases only.}
}
\value{
A list of two elements:

\item{K}{The minimum number of cases to just achieve the desired statistical power.}

\item{power}{The predicted statistical power.}
}
\description{
Calculate required number of cases to achieve the desired power for specified number of readers J and DBM or OR variability parameters.
}
\details{
To calculate the sample size, either the group of DBM variance components (\code{varYTR}, \code{varYTC}, and \code{varYEps}) or
OR covariance matrix elements and mean squares and number of cases in pilot study should be specified.
If both of them are given, DBM variance components are used and OR values are ignored. Specifically, either numeric
values of \code{varYTR}, \code{varYTC}, \code{varYEps} can be supplied, or the function call must explicitly state
\code{cov1 = value1}, \code{cov2 = value2}, \code{cov3 = value3}, \code{varEps = value4}, \code{msTR = value5},
\code{KStar = value6}, as is standard usage in R.
}
\examples{
## Following is an example of sample size calculation with DBM variance components.
retDbm <- DBMHAnalysis(data = rocData, fom = "Wilcoxon")
effectSize <- retDbm$ciDiffTrtRRRC$Estimate
varCompDBM <- retDbm$varComp
varYTR <- varCompDBM$varComp[3]
varYTC <- varCompDBM$varComp[4]
varYEps <- varCompDBM$varComp[6]
SampleSizeGivenJ(J = 6, varYTR = varYTR, varYTC = varYTC, varYEps = varYEps,
                 effectSize =effectSize)

## Following is an example of sample size calculation with OR variance components.
retOR <- ORHAnalysis(data = rocData, fom = "Wilcoxon", covEstMethod = "Jackknife")
effectSize <- retOR$ciDiffTrtRRRC$Estimate
varCompOR <- retOR$varComp
cov1 <- varCompOR$varCov[3]
cov2 <- varCompOR$varCov[4]
cov3 <- varCompOR$varCov[5]
varEps <- varCompOR$varCov[6]
msTR <- retOR$msTR
KStar <- 114
SampleSizeGivenJ(J = 6, cov1 = cov1, cov2 = cov2, cov3 = cov3, varEps= varEps,
                 msTR = msTR, KStar = KStar, effectSize =effectSize)

\dontrun{
## Following is an example of sample size calculation with DBM variance components,
## and scanning the number of readers
retDbm <- DBMHAnalysis(data = rocData, fom = "Wilcoxon")
effectSize <- retDbm$ciDiffTrtRRRC$Estimate
varYTR <- retDbm$varComp$varComp[3]
varYTC <- retDbm$varComp$varComp[4]
varYEps <- retDbm$varComp$varComp[6]
effectSize <- retDbm$ciDiffTrtRRRC$Estimate
for (J in 6:10) {
 ret <- SampleSizeGivenJ(J, varYTR, varYTC, varYEps, effectSize =effectSize)
 message("# of readers = ", J, " estimated # of cases = ", ret$K, ", predicted power = ",
    signif(ret$power,3), "\\n")
}

## Following is an example of sample size calculation with OR variance components,
## using bootstrap to estimate variance components
retOR <- ORHAnalysis(data = rocData, fom = "Wilcoxon", covEstMethod = "Bootstrap")
effectSize <- retOR$ciDiffTrtRRRC$Estimate
varCompOR <- retOR$varComp
cov1 <- varCompOR$varCov[3]
cov2 <- varCompOR$varCov[4]
cov3 <- varCompOR$varCov[5]
varEps <- varCompOR$varCov[6]
msTR <- retOR$msTR
KStar <- length(rocData$NL[1,1,,1])
SampleSizeGivenJ(J = 6, cov1 = cov1, cov2 = cov2, cov3 = cov3, varEps= varEps,
                 msTR = msTR, KStar = KStar, effectSize =effectSize)
}
}
\references{
Hillis, S. L., Obuchowski, N. A., & Berbaum, K. S. (2011). Power Estimation for Multireader ROC Methods: An Updated and Unified Approach. Acad Radiol, 18, 129-142.

Hillis, S. L., Obuchowski, N. A, Schartz, K. M., & Berbaum, K. S. (2005). A comparison of the Dorfman-Berbaum-Metz and Obuchowski-Rockette methods
for receiver operating characteristic (ROC) data. Statistics in Medicine, 24(10), 1579-607.
}

