% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilPseudoValues.R
\name{UtilPseudoValues}
\alias{UtilPseudoValues}
\title{Calculate pseudovalues}
\usage{
UtilPseudoValues(dataset, FOM = "Wilcoxon")
}
\arguments{
\item{dataset}{The dataset to be analyzed, see \code{\link{RJafroc-package}}.}

\item{FOM}{The figure of merit to be used in the calculation. 
The default is \code{"wJAFROC"}. See \code{\link{UtilFigureOfMerit}}.}
}
\value{
An \code{c(I, J, K)} array containing the pseudovalues of the datasets.
}
\description{
Calculates centered pseudovalues using the jackknife
}
\examples{
UtilPseudoValues(dataset02, FOM = "Wilcoxon")[1,1,1:10]
UtilPseudoValues(dataset05, FOM = "wAFROC")[1,1,1:10] # default FOM is wAFROC for this FROC dataset

}
