% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilLesionDistr.R
\name{UtilLesionDistr}
\alias{UtilLesionDistr}
\title{Lesion distribution  matrix}
\usage{
UtilLesionDistr(dataset)
}
\arguments{
\item{dataset}{The dataset}
}
\value{
The lesion distribution matrix
}
\description{
The lesion distribution matrix for a dataset.
}
\details{
lesDistr The lesion distribution matrix, an [1:nRow,2] array, where
   nRow is the number of \bold{unique} values of lesions per case 
   in the dataset. The first column contains the number of lesions. 
   The second column contains the fraction of diseased cases with the number 
   of lesions indicated in the first column. See 
   \link{PlotRsmOperatingCharacteristics} for a function that depends on 
   lesDistr. See Chapter00Vignette2 for more details.
}
\examples{
UtilLesionDistr (dataset01) # FROC data
UtilLesionDistr (dataset02) # ROC data
UtilLesionDistr (datasetCadLroc) # LROC data

}
