% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateRocDataset.R
\name{SimulateRocDataset}
\alias{SimulateRocDataset}
\title{Simulates a binormal model ROC dataset}
\usage{
SimulateRocDataset(I = 1, J = 1, K1, K2, a, b, seed = NULL)
}
\arguments{
\item{I}{The number of modalities, default is 1}

\item{J}{The number of readers, default is 1}

\item{K1}{The number of non-diseased cases}

\item{K2}{The number of diseased cases}

\item{a}{The \eqn{a} parameter of the binormal model}

\item{b}{The \eqn{b} parameter of the binormal model}

\item{seed}{The initial seed, default is NULL, which results in a random seed}
}
\value{
An ROC dataset
}
\description{
Simulates an uncorrelated binormal model ROC factorial dataset
}
\details{
See book Chapter 6 for details
}
\examples{
K1 <- 5;K2 <- 7;a <- 1.5;b <- 0.5
rocDataRaw <- SimulateRocDataset(K1 = K1, K2 = K2, a = a, b = b)
  
}
\references{
Chakraborty DP (2017) \emph{Observer Performance Methods for Diagnostic Imaging - Foundations, 
Modeling, and Applications with R-Based Examples}, CRC Press, Boca Raton, FL.
}
