% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilMeanSquares.R
\name{UtilMeanSquares}
\alias{UtilMeanSquares}
\title{Calculate mean squares for factorial dataset}
\usage{
UtilMeanSquares(dataset, FOM = "Wilcoxon", FPFValue = 0.2, method = "DBM")
}
\arguments{
\item{dataset}{The dataset to be analyzed, see \code{\link{RJafroc-package}}.}

\item{FOM}{The figure of merit to be used in the calculation. The default 
is \code{"FOM_wAFROC"}. See \code{\link{UtilFigureOfMerit}}.}

\item{FPFValue}{Only needed for \code{LROC} data \strong{and} FOM = "PCL" or "ALROC";
where to evaluate a partial curve based figure of merit. The default is 0.2.}

\item{method}{The method, in which the mean squares are calculated. The two 
valid choices are \code{"DBM"} (default) and \code{"OR"}.}
}
\value{
A list containing all possible mean squares
}
\description{
Calculates the mean squares used in the DBM and ORH methods for factorial dataset
}
\details{
For \code{DBM} method, \code{msT, msTR, msTC, msTRC} will not be available 
   if the dataset contains only one treatment. Similarly, 
   \code{msR, msTR, msRC, msTRC} will not be returned for single reader dataset. 
   For \code{ORH} method, \code{msT, msR, msTR} will be returned for multiple 
   reader multiple treatment dataset. \code{msT} is not available for single 
   treatment dataset, and \code{msR} is not available for single reader dataset.
}
\examples{
UtilMeanSquares(dataset02, FOM = "Wilcoxon")
UtilMeanSquares(dataset05, FOM = "wAFROC", method = "OR")

}
