% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{datasetROI}
\alias{datasetROI}
\title{Simulated ROI dataset}
\format{
A list with 3 elements: \code{$ratings}, \code{$lesions} and \code{$descriptions}; \code{$ratings}
   contain 3 elements, \code{$NL}, \code{$LL} and \code{$LL_IL} as sub-lists; \code{$lesions}
   contain 3 elements, \code{$perCase}, \code{$IDs} and \code{$weights} as sub-lists; \code{$descriptions}
   contain 7 elements, \code{$fileName}, \code{$type}, \code{$name},
   \code{$truthTableStr}, \code{$design}, \code{$modalityID} and \code{$readerID} as sub-lists;
\itemize{
\item{\code{rating$NL}}{, num [1:2, 1:5, 1:90, 1:4], ratings of non-lesion localizations, NLs}
\item{\code{rating$LL}}{, num [1:2, 1:5, 1:40, 1:4], ratings of lesion localizations, LLs}
\item{\code{rating$LL_IL}}{NA, this placeholder is used only for LROC data}
\item{\code{lesions$perCase}}{, int [1:40], number of lesions per diseased case}
\item{\code{lesions$IDs}}{, num [1:40, 1:4] , numeric labels of lesions on diseased cases}
\item{\code{lesions$weights}}{, num [1:40, 1:4], weights (or clinical importances) of lesions}
\item{\code{descriptions$fileName}}{, chr, "datasetROI", base name of dataset in `data` folder}
\item{\code{descriptions$type}}{, chr "ROI", the data type}
\item{\code{descriptions$name}}{, chr "SIM-ROI", the name of the dataset}
\item{\code{descriptions$truthTableStr}}{, NA, truth table structure}
\item{\code{descriptions$design}}{, chr "FCTRL-X-MOD", study design, factorial dataset}
\item{\code{descriptions$modalityID}}{, chr [1:2] "1" "2", treatment label(s)}
\item{\code{descriptions$readerID}}{, chr [1:5] "1" "2" "3" "4" ..., reader labels}
}
}
\usage{
datasetROI
}
\description{
TBA Simulated ROI dataset: assumed are 4 ROIs per case, 5 readers, 50 non-dieased and 40 diseased cases.
}
\examples{
str(datasetROI)


}
\keyword{datasets}
