/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model;

import com.hp.hpl.jena.rdf.model.ModelMakerCreator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.FileMakerCreator;
import com.hp.hpl.jena.rdf.model.impl.MemMakerCreator;
import com.hp.hpl.jena.rdf.model.impl.RDBMakerCreator;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import java.util.HashMap;
import java.util.Map;

public class ModelMakerCreatorRegistry {
    private static Map creators = new HashMap();
    private static final ModelMakerCreator defaultMakerCreator = new MemMakerCreator();

    private ModelMakerCreatorRegistry() {
    }

    public static ModelMakerCreator findCreator(Resource type) {
        return (ModelMakerCreator)creators.get(type);
    }

    public static void register(Resource type, ModelMakerCreator mmc) {
        creators.put(type, mmc);
    }

    static {
        ModelMakerCreatorRegistry.register(JenaModelSpec.MakerSpec, defaultMakerCreator);
        ModelMakerCreatorRegistry.register(JenaModelSpec.FileMakerSpec, new FileMakerCreator());
        ModelMakerCreatorRegistry.register(JenaModelSpec.MemMakerSpec, new MemMakerCreator());
        ModelMakerCreatorRegistry.register(JenaModelSpec.RDBMakerSpec, new RDBMakerCreator());
    }
}

