/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import java.util.Iterator;
import java.util.List;

public class ModelListenerAdapter
implements GraphListener {
    protected ModelCom m;
    protected ModelChangedListener L;

    public ModelListenerAdapter(ModelCom m, ModelChangedListener L) {
        this.m = m;
        this.L = L;
    }

    public void notifyAddArray(Graph graph, Triple[] triples) {
        this.L.addedStatements(this.m.asStatements(triples));
    }

    public void notifyDeleteArray(Graph g, Triple[] triples) {
        this.L.removedStatements(this.m.asStatements(triples));
    }

    public void notifyAddTriple(Graph g, Triple t) {
        this.L.addedStatement(this.m.asStatement(t));
    }

    public void notifyAddList(Graph g, List triples) {
        this.L.addedStatements(this.m.asStatements(triples));
    }

    public void notifyAddIterator(Graph g, Iterator it) {
        this.L.addedStatements(this.m.asStatements(it));
    }

    public void notifyAddGraph(Graph g, Graph added) {
        this.L.addedStatements(this.m.asModel(added));
    }

    public void notifyDeleteIterator(Graph g, Iterator it) {
        this.L.removedStatements(this.m.asStatements(it));
    }

    public void notifyDeleteTriple(Graph g, Triple t) {
        this.L.removedStatement(this.m.asStatement(t));
    }

    public void notifyAddIterator(Graph g, List triples) {
        this.L.addedStatements(this.m.asStatements(triples));
    }

    public void notifyDeleteList(Graph g, List triples) {
        this.L.removedStatements(this.m.asStatements(triples));
    }

    public void notifyDeleteGraph(Graph g, Graph removed) {
        this.L.removedStatements(this.m.asModel(removed));
    }

    public void notifyEvent(Graph g, Object event) {
        this.L.notifyEvent(this.m, event);
    }

    public boolean equals(Object other) {
        return other instanceof ModelListenerAdapter && ((ModelListenerAdapter)other).sameAs(this);
    }

    public boolean sameAs(ModelListenerAdapter other) {
        return this.L.equals(other.L) && this.m.equals(other.m);
    }
}

