/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.functions.Logistic;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.SMOset;
import weka.classifiers.mi.SimpleMI;
import weka.classifiers.mi.supportVector.MIPolyKernel;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.SelectedTag;
import weka.core.SerializedObject;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MultiInstanceToPropositional;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.PropositionalToMultiInstance;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class MISMO
extends Classifier
implements WeightedInstancesHandler,
MultiInstanceCapabilitiesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -5834036950143719712L;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected BinaryMISMO[][] m_classifiers = null;
    protected double m_C = 1.0;
    protected double m_eps = 1.0E-12;
    protected double m_tol = 0.001;
    protected int m_filterType = 0;
    protected boolean m_minimax = false;
    protected NominalToBinary m_NominalToBinary;
    protected Filter m_Filter = null;
    protected ReplaceMissingValues m_Missing;
    protected int m_classIndex = -1;
    protected Attribute m_classAttribute;
    protected Kernel m_kernel = new MIPolyKernel();
    protected boolean m_checksTurnedOff;
    protected static double m_Del = 4.94E-321;
    protected boolean m_fitLogisticModels = false;
    protected int m_numFolds = -1;
    protected int m_randomSeed = 1;

    public String globalInfo() {
        return "Implements John Platt's sequential minimal optimization algorithm for training a support vector classifier.\n\nThis implementation globally replaces all missing values and transforms nominal attributes into binary ones. It also normalizes all attributes by default. (In that case the coefficients in the output are based on the normalized data, not the original data --- this is important for interpreting the classifier.)\n\nMulti-class problems are solved using pairwise classification.\n\nTo obtain proper probability estimates, use the option that fits logistic regression models to the outputs of the support vector machine. In the multi-class case the predicted probabilities are coupled using Hastie and Tibshirani's pairwise coupling method.\n\nNote: for improved speed normalization should be turned off when operating on SparseInstances.\n\nFor more information on the SMO algorithm, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INCOLLECTION);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "J. Platt");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1998");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Machines using Sequential Minimal Optimization");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Advances in Kernel Methods - Support Vector Learning");
        technicalInformation.setValue(TechnicalInformation.Field.EDITOR, "B. Schoelkopf and C. Burges and A. Smola");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "MIT Press");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.ARTICLE);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "S.S. Keerthi and S.K. Shevade and C. Bhattacharyya and K.R.K. Murthy");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2001");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Improvements to Platt's SMO Algorithm for SVM Classifier Design");
        technicalInformation2.setValue(TechnicalInformation.Field.JOURNAL, "Neural Computation");
        technicalInformation2.setValue(TechnicalInformation.Field.VOLUME, "13");
        technicalInformation2.setValue(TechnicalInformation.Field.NUMBER, "3");
        technicalInformation2.setValue(TechnicalInformation.Field.PAGES, "637-649");
        return technicalInformation;
    }

    public void turnChecksOff() {
        this.m_checksTurnedOff = true;
    }

    public void turnChecksOn() {
        this.m_checksTurnedOff = false;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = this.getKernel().getCapabilities();
        capabilities.setOwner(this);
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.disableAllClasses();
        capabilities.disableAllClassDependencies();
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return capabilities;
    }

    public Capabilities getMultiInstanceCapabilities() {
        Capabilities capabilities = ((MultiInstanceCapabilitiesHandler)((Object)this.getKernel())).getMultiInstanceCapabilities();
        capabilities.setOwner(this);
        capabilities.enableAllAttributeDependencies();
        if (capabilities.handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        }
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        Instances instances2;
        Instances[] instancesArray;
        int n2;
        if (!this.m_checksTurnedOff) {
            this.getCapabilities().testWithFail(instances);
            instances = new Instances(instances);
            instances.deleteWithMissingClass();
            Instances instances3 = new Instances(instances, instances.numInstances());
            for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                if (!(instances.instance(n2).weight() > 0.0)) continue;
                instances3.add(instances.instance(n2));
            }
            if (instances3.numInstances() == 0) {
                throw new Exception("No training instances left after removing instance with either a weight null or a missing class!");
            }
            instances = instances3;
        }
        this.m_Missing = !this.m_checksTurnedOff ? new ReplaceMissingValues() : null;
        if (this.getCapabilities().handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            boolean bl = true;
            if (!this.m_checksTurnedOff) {
                for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
                    if (n2 == instances.classIndex() || instances.attribute(n2).isNumeric()) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) {
                this.m_NominalToBinary = new NominalToBinary();
                this.m_NominalToBinary.setAttributeIndices("2-last");
            } else {
                this.m_NominalToBinary = null;
            }
        } else {
            this.m_NominalToBinary = null;
        }
        this.m_Filter = this.m_filterType == 1 ? new Standardize() : (this.m_filterType == 0 ? new Normalize() : null);
        MultiInstanceToPropositional multiInstanceToPropositional = new MultiInstanceToPropositional();
        PropositionalToMultiInstance propositionalToMultiInstance = new PropositionalToMultiInstance();
        if (this.m_minimax) {
            instancesArray = new SimpleMI();
            instancesArray.setTransformMethod(new SelectedTag(3, SimpleMI.TAGS_TRANSFORMMETHOD));
            instances2 = instancesArray.transform(instances);
        } else {
            ((Filter)multiInstanceToPropositional).setInputFormat(instances);
            instances2 = Filter.useFilter(instances, multiInstanceToPropositional);
        }
        if (this.m_Missing != null) {
            this.m_Missing.setInputFormat(instances2);
            instances2 = Filter.useFilter(instances2, this.m_Missing);
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.setInputFormat(instances2);
            instances2 = Filter.useFilter(instances2, this.m_NominalToBinary);
        }
        if (this.m_Filter != null) {
            this.m_Filter.setInputFormat(instances2);
            instances2 = Filter.useFilter(instances2, this.m_Filter);
        }
        ((Filter)propositionalToMultiInstance).setInputFormat(instances2);
        instances = Filter.useFilter(instances2, propositionalToMultiInstance);
        this.m_classIndex = instances.classIndex();
        this.m_classAttribute = instances.classAttribute();
        instancesArray = new Instances[instances.numClasses()];
        for (n = 0; n < instances.numClasses(); ++n) {
            instancesArray[n] = new Instances(instances, instances.numInstances());
        }
        for (n = 0; n < instances.numInstances(); ++n) {
            Instance instance = instances.instance(n);
            instancesArray[(int)instance.classValue()].add(instance);
        }
        for (n = 0; n < instances.numClasses(); ++n) {
            instancesArray[n].compactify();
        }
        Random random = new Random(this.m_randomSeed);
        this.m_classifiers = new BinaryMISMO[instances.numClasses()][instances.numClasses()];
        for (int i = 0; i < instances.numClasses(); ++i) {
            for (int j = i + 1; j < instances.numClasses(); ++j) {
                int n3;
                this.m_classifiers[i][j] = new BinaryMISMO();
                this.m_classifiers[i][j].setKernel(Kernel.makeCopy(this.getKernel()));
                Instances instances4 = new Instances(instances, instances.numInstances());
                for (n3 = 0; n3 < instancesArray[i].numInstances(); ++n3) {
                    instances4.add(instancesArray[i].instance(n3));
                }
                for (n3 = 0; n3 < instancesArray[j].numInstances(); ++n3) {
                    instances4.add(instancesArray[j].instance(n3));
                }
                instances4.compactify();
                instances4.randomize(random);
                this.m_classifiers[i][j].buildClassifier(instances4, i, j, this.m_fitLogisticModels, this.m_numFolds, this.m_randomSeed);
            }
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        Object object;
        Instances instances = new Instances(instance.dataset(), 0);
        instances.add(instance);
        MultiInstanceToPropositional multiInstanceToPropositional = new MultiInstanceToPropositional();
        PropositionalToMultiInstance propositionalToMultiInstance = new PropositionalToMultiInstance();
        if (this.m_minimax) {
            object = new SimpleMI();
            ((SimpleMI)object).setTransformMethod(new SelectedTag(3, SimpleMI.TAGS_TRANSFORMMETHOD));
            instances = ((SimpleMI)object).transform(instances);
        } else {
            ((Filter)multiInstanceToPropositional).setInputFormat(instances);
            instances = Filter.useFilter(instances, multiInstanceToPropositional);
        }
        if (this.m_Missing != null) {
            instances = Filter.useFilter(instances, this.m_Missing);
        }
        if (this.m_Filter != null) {
            instances = Filter.useFilter(instances, this.m_Filter);
        }
        ((Filter)propositionalToMultiInstance).setInputFormat(instances);
        instances = Filter.useFilter(instances, propositionalToMultiInstance);
        instance = instances.instance(0);
        if (!this.m_fitLogisticModels) {
            object = new double[instance.numClasses()];
            for (int i = 0; i < instance.numClasses(); ++i) {
                for (int j = i + 1; j < instance.numClasses(); ++j) {
                    if (this.m_classifiers[i][j].m_alpha == null && this.m_classifiers[i][j].m_sparseWeights == null) continue;
                    double d = this.m_classifiers[i][j].SVMOutput(-1, instance);
                    if (d > 0.0) {
                        Object object2 = object;
                        int n = j;
                        object2[n] = object2[n] + 1.0;
                        continue;
                    }
                    Object object3 = object;
                    int n = i;
                    object3[n] = object3[n] + 1.0;
                }
            }
            Utils.normalize((double[])object);
            return object;
        }
        if (instance.numClasses() == 2) {
            object = new double[2];
            object[0] = this.m_classifiers[0][1].SVMOutput(-1, instance);
            object[1] = Instance.missingValue();
            return this.m_classifiers[0][1].m_logistic.distributionForInstance(new Instance(1.0, (double[])object));
        }
        object = new double[instance.numClasses()][instance.numClasses()];
        double[][] dArray = new double[instance.numClasses()][instance.numClasses()];
        for (int i = 0; i < instance.numClasses(); ++i) {
            for (int j = i + 1; j < instance.numClasses(); ++j) {
                if (this.m_classifiers[i][j].m_alpha == null && this.m_classifiers[i][j].m_sparseWeights == null) continue;
                double[] dArray2 = new double[]{this.m_classifiers[i][j].SVMOutput(-1, instance), Instance.missingValue()};
                object[i][j] = this.m_classifiers[i][j].m_logistic.distributionForInstance(new Instance(1.0, dArray2))[0];
                dArray[i][j] = this.m_classifiers[i][j].m_sumOfWeights;
            }
        }
        return this.pairwiseCoupling(dArray, (double[][])object);
    }

    public double[] pairwiseCoupling(double[][] dArray, double[][] dArray2) {
        int n;
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = 1.0 / (double)dArray3.length;
        }
        double[][] dArray4 = new double[dArray2.length][dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (n = i + 1; n < dArray2.length; ++n) {
                dArray4[i][n] = 0.5;
            }
        }
        double[] dArray5 = new double[dArray3.length];
        for (n = 0; n < dArray3.length; ++n) {
            for (int i = n + 1; i < dArray3.length; ++i) {
                int n2 = n;
                dArray5[n2] = dArray5[n2] + dArray[n][i] * dArray2[n][i];
                int n3 = i;
                dArray5[n3] = dArray5[n3] + dArray[n][i] * (1.0 - dArray2[n][i]);
            }
        }
        do {
            int n4;
            n = 0;
            double[] dArray6 = new double[dArray3.length];
            for (n4 = 0; n4 < dArray3.length; ++n4) {
                for (int i = n4 + 1; i < dArray3.length; ++i) {
                    int n5 = n4;
                    dArray6[n5] = dArray6[n5] + dArray[n4][i] * dArray4[n4][i];
                    int n6 = i;
                    dArray6[n6] = dArray6[n6] + dArray[n4][i] * (1.0 - dArray4[n4][i]);
                }
            }
            for (n4 = 0; n4 < dArray3.length; ++n4) {
                if (dArray5[n4] == 0.0 || dArray6[n4] == 0.0) {
                    if (dArray3[n4] > 0.0) {
                        n = 1;
                    }
                    dArray3[n4] = 0.0;
                    continue;
                }
                double d = dArray5[n4] / dArray6[n4];
                double d2 = dArray3[n4];
                int n7 = n4;
                dArray3[n7] = dArray3[n7] * d;
                if (!(Math.abs(d2 - dArray3[n4]) > 0.001)) continue;
                n = 1;
            }
            Utils.normalize(dArray3);
            for (n4 = 0; n4 < dArray2.length; ++n4) {
                for (int i = n4 + 1; i < dArray2.length; ++i) {
                    dArray4[n4][i] = dArray3[n4] / (dArray3[n4] + dArray3[i]);
                }
            }
        } while (n != 0);
        return dArray3;
    }

    public double[][][] sparseWeights() {
        int n = this.m_classAttribute.numValues();
        double[][][] dArray = new double[n][n][];
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                dArray[i][j] = this.m_classifiers[i][j].m_sparseWeights;
            }
        }
        return dArray;
    }

    public int[][][] sparseIndices() {
        int n = this.m_classAttribute.numValues();
        int[][][] nArray = new int[n][n][];
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                nArray[i][j] = this.m_classifiers[i][j].m_sparseIndices;
            }
        }
        return nArray;
    }

    public double[][] bias() {
        int n = this.m_classAttribute.numValues();
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                dArray[i][j] = this.m_classifiers[i][j].m_b;
            }
        }
        return dArray;
    }

    public int numClassAttributeValues() {
        return this.m_classAttribute.numValues();
    }

    public String[] classAttributeNames() {
        int n = this.m_classAttribute.numValues();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_classAttribute.value(i);
        }
        return stringArray;
    }

    public String[][][] attributeNames() {
        int n = this.m_classAttribute.numValues();
        String[][][] stringArray = new String[n][n][];
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int n2 = this.m_classifiers[i][j].m_data.numAttributes();
                String[] stringArray2 = new String[n2];
                for (int k = 0; k < n2; ++k) {
                    stringArray2[k] = this.m_classifiers[i][j].m_data.attribute(k).name();
                }
                stringArray[i][j] = stringArray2;
            }
        }
        return stringArray;
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tTurns off all checks - use with caution!\n\tTurning them off assumes that data is purely numeric, doesn't\n\tcontain any missing values, and has a nominal class. Turning them\n\toff also means that no header information will be stored if the\n\tmachine is linear. Finally, it also assumes that no instance has\n\ta weight equal to 0.\n\t(default: checks on)", "no-checks", 0, "-no-checks"));
        vector.addElement(new Option("\tThe complexity constant C. (default 1)", "C", 1, "-C <double>"));
        vector.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither.\n\t(default 0=normalize)", "N", 1, "-N"));
        vector.addElement(new Option("\tUse MIminimax feature space. ", "I", 0, "-I"));
        vector.addElement(new Option("\tThe tolerance parameter. (default 1.0e-3)", "L", 1, "-L <double>"));
        vector.addElement(new Option("\tThe epsilon for round-off error. (default 1.0e-12)", "P", 1, "-P <double>"));
        vector.addElement(new Option("\tFit logistic models to SVM outputs. ", "M", 0, "-M"));
        vector.addElement(new Option("\tThe number of folds for the internal cross-validation. \n\t(default -1, use training data)", "V", 1, "-V <double>"));
        vector.addElement(new Option("\tThe random number seed. (default 1)", "W", 1, "-W <double>"));
        vector.addElement(new Option("\tThe Kernel to use.\n\t(default: weka.classifiers.functions.supportVector.PolyKernel)", "K", 1, "-K <classname and parameters>"));
        vector.addElement(new Option("", "", 0, "\nOptions specific to kernel " + this.getKernel().getClass().getName() + ":"));
        enumeration = this.getKernel().listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setChecksTurnedOff(Utils.getFlag("no-checks", stringArray));
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setC(Double.parseDouble(string));
        } else {
            this.setC(1.0);
        }
        string = Utils.getOption('L', stringArray);
        if (string.length() != 0) {
            this.setToleranceParameter(Double.parseDouble(string));
        } else {
            this.setToleranceParameter(0.001);
        }
        string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setEpsilon(new Double(string));
        } else {
            this.setEpsilon(1.0E-12);
        }
        this.setMinimax(Utils.getFlag('I', stringArray));
        string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(string), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
        this.setBuildLogisticModels(Utils.getFlag('M', stringArray));
        string = Utils.getOption('V', stringArray);
        this.m_numFolds = string.length() != 0 ? Integer.parseInt(string) : -1;
        string = Utils.getOption('W', stringArray);
        if (string.length() != 0) {
            this.setRandomSeed(Integer.parseInt(string));
        } else {
            this.setRandomSeed(1);
        }
        string = Utils.getOption('K', stringArray);
        String[] stringArray2 = Utils.splitOptions(string);
        if (stringArray2.length != 0) {
            string = stringArray2[0];
            stringArray2[0] = "";
            this.setKernel(Kernel.forName(string, stringArray2));
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (this.getChecksTurnedOff()) {
            vector.add("-no-checks");
        }
        vector.add("-C");
        vector.add("" + this.getC());
        vector.add("-L");
        vector.add("" + this.getToleranceParameter());
        vector.add("-P");
        vector.add("" + this.getEpsilon());
        vector.add("-N");
        vector.add("" + this.m_filterType);
        if (this.getMinimax()) {
            vector.add("-I");
        }
        if (this.getBuildLogisticModels()) {
            vector.add("-M");
        }
        vector.add("-V");
        vector.add("" + this.getNumFolds());
        vector.add("-W");
        vector.add("" + this.getRandomSeed());
        vector.add("-K");
        vector.add("" + this.getKernel().getClass().getName() + " " + Utils.joinOptions(this.getKernel().getOptions()));
        return vector.toArray(new String[vector.size()]);
    }

    public void setChecksTurnedOff(boolean bl) {
        if (bl) {
            this.turnChecksOff();
        } else {
            this.turnChecksOn();
        }
    }

    public boolean getChecksTurnedOff() {
        return this.m_checksTurnedOff;
    }

    public String checksTurnedOffTipText() {
        return "Turns time-consuming checks off - use with caution.";
    }

    public String kernelTipText() {
        return "The kernel to use.";
    }

    public Kernel getKernel() {
        return this.m_kernel;
    }

    public void setKernel(Kernel kernel) {
        if (!(kernel instanceof MultiInstanceCapabilitiesHandler)) {
            throw new IllegalArgumentException("Kernel must be able to handle multi-instance data!\n(This one does not implement " + MultiInstanceCapabilitiesHandler.class.getName() + ")");
        }
        this.m_kernel = kernel;
    }

    public String cTipText() {
        return "The complexity parameter C.";
    }

    public double getC() {
        return this.m_C;
    }

    public void setC(double d) {
        this.m_C = d;
    }

    public String toleranceParameterTipText() {
        return "The tolerance parameter (shouldn't be changed).";
    }

    public double getToleranceParameter() {
        return this.m_tol;
    }

    public void setToleranceParameter(double d) {
        this.m_tol = d;
    }

    public String epsilonTipText() {
        return "The epsilon for round-off error (shouldn't be changed).";
    }

    public double getEpsilon() {
        return this.m_eps;
    }

    public void setEpsilon(double d) {
        this.m_eps = d;
    }

    public String filterTypeTipText() {
        return "Determines how/if the data will be transformed.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_FILTER) {
            this.m_filterType = selectedTag.getSelectedTag().getID();
        }
    }

    public String minimaxTipText() {
        return "Whether the MIMinimax feature space is to be used.";
    }

    public boolean getMinimax() {
        return this.m_minimax;
    }

    public void setMinimax(boolean bl) {
        this.m_minimax = bl;
    }

    public String buildLogisticModelsTipText() {
        return "Whether to fit logistic models to the outputs (for proper probability estimates).";
    }

    public boolean getBuildLogisticModels() {
        return this.m_fitLogisticModels;
    }

    public void setBuildLogisticModels(boolean bl) {
        this.m_fitLogisticModels = bl;
    }

    public String numFoldsTipText() {
        return "The number of folds for cross-validation used to generate training data for logistic models (-1 means use training data).";
    }

    public int getNumFolds() {
        return this.m_numFolds;
    }

    public void setNumFolds(int n) {
        this.m_numFolds = n;
    }

    public String randomSeedTipText() {
        return "Random number seed for the cross-validation.";
    }

    public int getRandomSeed() {
        return this.m_randomSeed;
    }

    public void setRandomSeed(int n) {
        this.m_randomSeed = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_classAttribute == null) {
            return "SMO: No model built yet.";
        }
        try {
            stringBuffer.append("SMO\n\n");
            for (int i = 0; i < this.m_classAttribute.numValues(); ++i) {
                for (int j = i + 1; j < this.m_classAttribute.numValues(); ++j) {
                    stringBuffer.append("Classifier for classes: " + this.m_classAttribute.value(i) + ", " + this.m_classAttribute.value(j) + "\n\n");
                    stringBuffer.append(this.m_classifiers[i][j]);
                    if (this.m_fitLogisticModels) {
                        stringBuffer.append("\n\n");
                        if (this.m_classifiers[i][j].m_logistic == null) {
                            stringBuffer.append("No logistic model has been fit.\n");
                        } else {
                            stringBuffer.append(this.m_classifiers[i][j].m_logistic);
                        }
                    }
                    stringBuffer.append("\n\n");
                }
            }
        }
        catch (Exception exception) {
            return "Can't print SMO classifier.";
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        MISMO.runClassifier(new MISMO(), stringArray);
    }

    protected class BinaryMISMO
    implements Serializable {
        static final long serialVersionUID = -7107082483475433531L;
        protected double[] m_alpha;
        protected double m_b;
        protected double m_bLow;
        protected double m_bUp;
        protected int m_iLow;
        protected int m_iUp;
        protected Instances m_data;
        protected double[] m_weights;
        protected double[] m_sparseWeights;
        protected int[] m_sparseIndices;
        protected Kernel m_kernel;
        protected double[] m_class;
        protected double[] m_errors;
        protected SMOset m_I0;
        protected SMOset m_I1;
        protected SMOset m_I2;
        protected SMOset m_I3;
        protected SMOset m_I4;
        protected SMOset m_supportVectors;
        protected Logistic m_logistic = null;
        protected double m_sumOfWeights = 0.0;

        protected BinaryMISMO() {
        }

        protected void fitLogistic(Instances instances, int n, int n2, int n3, Random random) throws Exception {
            FastVector fastVector = new FastVector(2);
            fastVector.addElement(new Attribute("pred"));
            FastVector fastVector2 = new FastVector(2);
            fastVector2.addElement(instances.classAttribute().value(n));
            fastVector2.addElement(instances.classAttribute().value(n2));
            fastVector.addElement(new Attribute("class", fastVector2));
            Instances instances2 = new Instances("data", fastVector, instances.numInstances());
            instances2.setClassIndex(1);
            if (n3 <= 0) {
                for (int i = 0; i < instances.numInstances(); ++i) {
                    Instance instance = instances.instance(i);
                    double[] dArray = new double[2];
                    dArray[0] = this.SVMOutput(-1, instance);
                    if (instance.classValue() == (double)n2) {
                        dArray[1] = 1.0;
                    }
                    instances2.add(new Instance(instance.weight(), dArray));
                }
            } else {
                if (n3 > instances.numInstances()) {
                    n3 = instances.numInstances();
                }
                instances = new Instances(instances);
                instances.randomize(random);
                instances.stratify(n3);
                for (int i = 0; i < n3; ++i) {
                    Instances instances3 = instances.trainCV(n3, i, random);
                    SerializedObject serializedObject = new SerializedObject(this);
                    BinaryMISMO binaryMISMO = (BinaryMISMO)serializedObject.getObject();
                    binaryMISMO.buildClassifier(instances3, n, n2, false, -1, -1);
                    Instances instances4 = instances.testCV(n3, i);
                    for (int j = 0; j < instances4.numInstances(); ++j) {
                        double[] dArray = new double[2];
                        dArray[0] = binaryMISMO.SVMOutput(-1, instances4.instance(j));
                        if (instances4.instance(j).classValue() == (double)n2) {
                            dArray[1] = 1.0;
                        }
                        instances2.add(new Instance(instances4.instance(j).weight(), dArray));
                    }
                }
            }
            this.m_logistic = new Logistic();
            this.m_logistic.buildClassifier(instances2);
        }

        public void setKernel(Kernel kernel) {
            this.m_kernel = kernel;
        }

        public Kernel getKernel() {
            return this.m_kernel;
        }

        protected void buildClassifier(Instances instances, int n, int n2, boolean bl, int n3, int n4) throws Exception {
            int n5;
            this.m_bUp = -1.0;
            this.m_bLow = 1.0;
            this.m_b = 0.0;
            this.m_alpha = null;
            this.m_data = null;
            this.m_weights = null;
            this.m_errors = null;
            this.m_logistic = null;
            this.m_I0 = null;
            this.m_I1 = null;
            this.m_I2 = null;
            this.m_I3 = null;
            this.m_I4 = null;
            this.m_sparseWeights = null;
            this.m_sparseIndices = null;
            this.m_sumOfWeights = instances.sumOfWeights();
            this.m_class = new double[instances.numInstances()];
            this.m_iUp = -1;
            this.m_iLow = -1;
            for (n5 = 0; n5 < this.m_class.length; ++n5) {
                if ((int)instances.instance(n5).classValue() == n) {
                    this.m_class[n5] = -1.0;
                    this.m_iLow = n5;
                    continue;
                }
                if ((int)instances.instance(n5).classValue() == n2) {
                    this.m_class[n5] = 1.0;
                    this.m_iUp = n5;
                    continue;
                }
                throw new Exception("This should never happen!");
            }
            if (this.m_iUp == -1 || this.m_iLow == -1) {
                if (this.m_iUp != -1) {
                    this.m_b = -1.0;
                } else if (this.m_iLow != -1) {
                    this.m_b = 1.0;
                } else {
                    this.m_class = null;
                    return;
                }
                this.m_supportVectors = new SMOset(0);
                this.m_alpha = new double[0];
                this.m_class = new double[0];
                if (bl) {
                    this.fitLogistic(instances, n, n2, n3, new Random(n4));
                }
                return;
            }
            this.m_data = instances;
            this.m_weights = null;
            this.m_alpha = new double[this.m_data.numInstances()];
            this.m_supportVectors = new SMOset(this.m_data.numInstances());
            this.m_I0 = new SMOset(this.m_data.numInstances());
            this.m_I1 = new SMOset(this.m_data.numInstances());
            this.m_I2 = new SMOset(this.m_data.numInstances());
            this.m_I3 = new SMOset(this.m_data.numInstances());
            this.m_I4 = new SMOset(this.m_data.numInstances());
            this.m_sparseWeights = null;
            this.m_sparseIndices = null;
            this.m_errors = new double[this.m_data.numInstances()];
            this.m_errors[this.m_iLow] = 1.0;
            this.m_errors[this.m_iUp] = -1.0;
            this.m_kernel.buildKernel(this.m_data);
            for (n5 = 0; n5 < this.m_class.length; ++n5) {
                if (this.m_class[n5] == 1.0) {
                    this.m_I1.insert(n5);
                    continue;
                }
                this.m_I4.insert(n5);
            }
            n5 = 0;
            boolean bl2 = true;
            while (n5 > 0 || bl2) {
                int n6;
                n5 = 0;
                if (bl2) {
                    for (n6 = 0; n6 < this.m_alpha.length; ++n6) {
                        if (!this.examineExample(n6)) continue;
                        ++n5;
                    }
                } else {
                    for (n6 = 0; n6 < this.m_alpha.length; ++n6) {
                        if (!(this.m_alpha[n6] > 0.0) || !(this.m_alpha[n6] < MISMO.this.m_C * this.m_data.instance(n6).weight())) continue;
                        if (this.examineExample(n6)) {
                            ++n5;
                        }
                        if (!(this.m_bUp > this.m_bLow - 2.0 * MISMO.this.m_tol)) continue;
                        n5 = 0;
                        break;
                    }
                }
                if (bl2) {
                    bl2 = false;
                    continue;
                }
                if (n5 != 0) continue;
                bl2 = true;
            }
            this.m_b = (this.m_bLow + this.m_bUp) / 2.0;
            this.m_kernel.clean();
            this.m_errors = null;
            this.m_I4 = null;
            this.m_I3 = null;
            this.m_I2 = null;
            this.m_I1 = null;
            this.m_I0 = null;
            if (bl) {
                this.fitLogistic(instances, n, n2, n3, new Random(n4));
            }
        }

        protected double SVMOutput(int n, Instance instance) throws Exception {
            double d = 0.0;
            int n2 = this.m_supportVectors.getNext(-1);
            while (n2 != -1) {
                d += this.m_class[n2] * this.m_alpha[n2] * this.m_kernel.eval(n, n2, instance);
                n2 = this.m_supportVectors.getNext(n2);
            }
            return d -= this.m_b;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            if (this.m_alpha == null && this.m_sparseWeights == null) {
                return "BinaryMISMO: No model built yet.\n";
            }
            try {
                int n2;
                stringBuffer.append("BinaryMISMO\n\n");
                for (n2 = 0; n2 < this.m_alpha.length; ++n2) {
                    if (!this.m_supportVectors.contains(n2)) continue;
                    double d = this.m_alpha[n2];
                    if (this.m_class[n2] == 1.0) {
                        if (n > 0) {
                            stringBuffer.append(" + ");
                        }
                    } else {
                        stringBuffer.append(" - ");
                    }
                    stringBuffer.append(Utils.doubleToString(d, 12, 4) + " * <");
                    for (int i = 0; i < this.m_data.numAttributes(); ++i) {
                        if (i != this.m_data.classIndex()) {
                            stringBuffer.append(this.m_data.instance(n2).toString(i));
                        }
                        if (i == this.m_data.numAttributes() - 1) continue;
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("> * X]\n");
                    ++n;
                }
                if (this.m_b > 0.0) {
                    stringBuffer.append(" - " + Utils.doubleToString(this.m_b, 12, 4));
                } else {
                    stringBuffer.append(" + " + Utils.doubleToString(-this.m_b, 12, 4));
                }
                stringBuffer.append("\n\nNumber of support vectors: " + this.m_supportVectors.numElements());
                n2 = 0;
                int n3 = -1;
                if (this.m_kernel != null) {
                    n2 = this.m_kernel.numEvals();
                    n3 = this.m_kernel.numCacheHits();
                }
                stringBuffer.append("\n\nNumber of kernel evaluations: " + n2);
                if (n3 >= 0 && n2 > 0) {
                    double d = 1.0 - (double)n2 * 1.0 / (double)(n3 + n2);
                    stringBuffer.append(" (" + Utils.doubleToString(d * 100.0, 7, 3).trim() + "% cached)");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "Can't print BinaryMISMO classifier.";
            }
            return stringBuffer.toString();
        }

        protected boolean examineExample(int n) throws Exception {
            double d;
            int n2 = -1;
            double d2 = this.m_class[n];
            if (this.m_I0.contains(n)) {
                d = this.m_errors[n];
            } else {
                this.m_errors[n] = d = this.SVMOutput(n, this.m_data.instance(n)) + this.m_b - d2;
                if ((this.m_I1.contains(n) || this.m_I2.contains(n)) && d < this.m_bUp) {
                    this.m_bUp = d;
                    this.m_iUp = n;
                } else if ((this.m_I3.contains(n) || this.m_I4.contains(n)) && d > this.m_bLow) {
                    this.m_bLow = d;
                    this.m_iLow = n;
                }
            }
            boolean bl = true;
            if ((this.m_I0.contains(n) || this.m_I1.contains(n) || this.m_I2.contains(n)) && this.m_bLow - d > 2.0 * MISMO.this.m_tol) {
                bl = false;
                n2 = this.m_iLow;
            }
            if ((this.m_I0.contains(n) || this.m_I3.contains(n) || this.m_I4.contains(n)) && d - this.m_bUp > 2.0 * MISMO.this.m_tol) {
                bl = false;
                n2 = this.m_iUp;
            }
            if (bl) {
                return false;
            }
            if (this.m_I0.contains(n)) {
                n2 = this.m_bLow - d > d - this.m_bUp ? this.m_iLow : this.m_iUp;
            }
            if (n2 == -1) {
                throw new Exception("This should never happen!");
            }
            return this.takeStep(n2, n, d);
        }

        protected boolean takeStep(int n, int n2, double d) throws Exception {
            double d2;
            double d3;
            double d4;
            double d5;
            double d6 = MISMO.this.m_C * this.m_data.instance(n).weight();
            double d7 = MISMO.this.m_C * this.m_data.instance(n2).weight();
            if (n == n2) {
                return false;
            }
            double d8 = this.m_alpha[n];
            double d9 = this.m_alpha[n2];
            double d10 = this.m_class[n];
            double d11 = this.m_class[n2];
            double d12 = this.m_errors[n];
            double d13 = d10 * d11;
            if (d10 != d11) {
                d5 = Math.max(0.0, d9 - d8);
                d4 = Math.min(d7, d6 + d9 - d8);
            } else {
                d5 = Math.max(0.0, d8 + d9 - d6);
                d4 = Math.min(d7, d8 + d9);
            }
            if (d5 >= d4) {
                return false;
            }
            double d14 = this.m_kernel.eval(n, n, this.m_data.instance(n));
            double d15 = this.m_kernel.eval(n, n2, this.m_data.instance(n));
            double d16 = 2.0 * d15 - d14 - (d3 = this.m_kernel.eval(n2, n2, this.m_data.instance(n2)));
            if (d16 < 0.0) {
                d2 = d9 - d11 * (d12 - d) / d16;
                if (d2 < d5) {
                    d2 = d5;
                } else if (d2 > d4) {
                    d2 = d4;
                }
            } else {
                double d17;
                double d18;
                double d19;
                double d20 = d8 + d13 * d9;
                double d21 = this.SVMOutput(n, this.m_data.instance(n));
                double d22 = d21 + this.m_b - d10 * d8 * d14 - d11 * d9 * d15;
                double d23 = d20 - d13 * d5 + d5 - 0.5 * d14 * (d20 - d13 * d5) * (d20 - d13 * d5) - 0.5 * d3 * d5 * d5 - d13 * d15 * (d20 - d13 * d5) * d5 - d10 * (d20 - d13 * d5) * d22 - d11 * d5 * (d19 = (d18 = this.SVMOutput(n2, this.m_data.instance(n2))) + this.m_b - d10 * d8 * d15 - d11 * d9 * d3);
                d2 = d23 > (d17 = d20 - d13 * d4 + d4 - 0.5 * d14 * (d20 - d13 * d4) * (d20 - d13 * d4) - 0.5 * d3 * d4 * d4 - d13 * d15 * (d20 - d13 * d4) * d4 - d10 * (d20 - d13 * d4) * d22 - d11 * d4 * d19) + MISMO.this.m_eps ? d5 : (d23 < d17 - MISMO.this.m_eps ? d4 : d9);
            }
            if (Math.abs(d2 - d9) < MISMO.this.m_eps * (d2 + d9 + MISMO.this.m_eps)) {
                return false;
            }
            if (d2 > d7 - m_Del * d7) {
                d2 = d7;
            } else if (d2 <= m_Del * d7) {
                d2 = 0.0;
            }
            double d24 = d8 + d13 * (d9 - d2);
            if (d24 > d6 - m_Del * d6) {
                d24 = d6;
            } else if (d24 <= m_Del * d6) {
                d24 = 0.0;
            }
            if (d24 > 0.0) {
                this.m_supportVectors.insert(n);
            } else {
                this.m_supportVectors.delete(n);
            }
            if (d24 > 0.0 && d24 < d6) {
                this.m_I0.insert(n);
            } else {
                this.m_I0.delete(n);
            }
            if (d10 == 1.0 && d24 == 0.0) {
                this.m_I1.insert(n);
            } else {
                this.m_I1.delete(n);
            }
            if (d10 == -1.0 && d24 == d6) {
                this.m_I2.insert(n);
            } else {
                this.m_I2.delete(n);
            }
            if (d10 == 1.0 && d24 == d6) {
                this.m_I3.insert(n);
            } else {
                this.m_I3.delete(n);
            }
            if (d10 == -1.0 && d24 == 0.0) {
                this.m_I4.insert(n);
            } else {
                this.m_I4.delete(n);
            }
            if (d2 > 0.0) {
                this.m_supportVectors.insert(n2);
            } else {
                this.m_supportVectors.delete(n2);
            }
            if (d2 > 0.0 && d2 < d7) {
                this.m_I0.insert(n2);
            } else {
                this.m_I0.delete(n2);
            }
            if (d11 == 1.0 && d2 == 0.0) {
                this.m_I1.insert(n2);
            } else {
                this.m_I1.delete(n2);
            }
            if (d11 == -1.0 && d2 == d7) {
                this.m_I2.insert(n2);
            } else {
                this.m_I2.delete(n2);
            }
            if (d11 == 1.0 && d2 == d7) {
                this.m_I3.insert(n2);
            } else {
                this.m_I3.delete(n2);
            }
            if (d11 == -1.0 && d2 == 0.0) {
                this.m_I4.insert(n2);
            } else {
                this.m_I4.delete(n2);
            }
            int n3 = this.m_I0.getNext(-1);
            while (n3 != -1) {
                if (n3 != n && n3 != n2) {
                    int n4 = n3;
                    this.m_errors[n4] = this.m_errors[n4] + (d10 * (d24 - d8) * this.m_kernel.eval(n, n3, this.m_data.instance(n)) + d11 * (d2 - d9) * this.m_kernel.eval(n2, n3, this.m_data.instance(n2)));
                }
                n3 = this.m_I0.getNext(n3);
            }
            int n5 = n;
            this.m_errors[n5] = this.m_errors[n5] + (d10 * (d24 - d8) * d14 + d11 * (d2 - d9) * d15);
            int n6 = n2;
            this.m_errors[n6] = this.m_errors[n6] + (d10 * (d24 - d8) * d15 + d11 * (d2 - d9) * d3);
            this.m_alpha[n] = d24;
            this.m_alpha[n2] = d2;
            this.m_bLow = -1.7976931348623157E308;
            this.m_bUp = Double.MAX_VALUE;
            this.m_iLow = -1;
            this.m_iUp = -1;
            n3 = this.m_I0.getNext(-1);
            while (n3 != -1) {
                if (this.m_errors[n3] < this.m_bUp) {
                    this.m_bUp = this.m_errors[n3];
                    this.m_iUp = n3;
                }
                if (this.m_errors[n3] > this.m_bLow) {
                    this.m_bLow = this.m_errors[n3];
                    this.m_iLow = n3;
                }
                n3 = this.m_I0.getNext(n3);
            }
            if (!this.m_I0.contains(n)) {
                if (this.m_I3.contains(n) || this.m_I4.contains(n)) {
                    if (this.m_errors[n] > this.m_bLow) {
                        this.m_bLow = this.m_errors[n];
                        this.m_iLow = n;
                    }
                } else if (this.m_errors[n] < this.m_bUp) {
                    this.m_bUp = this.m_errors[n];
                    this.m_iUp = n;
                }
            }
            if (!this.m_I0.contains(n2)) {
                if (this.m_I3.contains(n2) || this.m_I4.contains(n2)) {
                    if (this.m_errors[n2] > this.m_bLow) {
                        this.m_bLow = this.m_errors[n2];
                        this.m_iLow = n2;
                    }
                } else if (this.m_errors[n2] < this.m_bUp) {
                    this.m_bUp = this.m_errors[n2];
                    this.m_iUp = n2;
                }
            }
            if (this.m_iLow == -1 || this.m_iUp == -1) {
                throw new Exception("This should never happen!");
            }
            return true;
        }

        protected void checkClassifier() throws Exception {
            int n;
            double d = 0.0;
            for (n = 0; n < this.m_alpha.length; ++n) {
                if (!(this.m_alpha[n] > 0.0)) continue;
                d += this.m_class[n] * this.m_alpha[n];
            }
            System.err.println("Sum of y(i) * alpha(i): " + d);
            for (n = 0; n < this.m_alpha.length; ++n) {
                double d2 = this.SVMOutput(n, this.m_data.instance(n));
                if (Utils.eq(this.m_alpha[n], 0.0) && Utils.sm(this.m_class[n] * d2, 1.0)) {
                    System.err.println("KKT condition 1 violated: " + this.m_class[n] * d2);
                }
                if (Utils.gr(this.m_alpha[n], 0.0) && Utils.sm(this.m_alpha[n], MISMO.this.m_C * this.m_data.instance(n).weight()) && !Utils.eq(this.m_class[n] * d2, 1.0)) {
                    System.err.println("KKT condition 2 violated: " + this.m_class[n] * d2);
                }
                if (!Utils.eq(this.m_alpha[n], MISMO.this.m_C * this.m_data.instance(n).weight()) || !Utils.gr(this.m_class[n] * d2, 1.0)) continue;
                System.err.println("KKT condition 3 violated: " + this.m_class[n] * d2);
            }
        }
    }
}

