/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DBPropLSet;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.PSet_ReifStore_RDB;
import com.hp.hpl.jena.db.impl.ResultSetReifIterator;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraphBase;
import com.hp.hpl.jena.db.impl.SpecializedGraphReifier;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.AlreadyReifiedException;
import com.hp.hpl.jena.shared.CannotReifyException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SpecializedGraphReifier_RDB
extends SpecializedGraphBase
implements SpecializedGraphReifier {
    public PSet_ReifStore_RDB m_pset;
    public DBPropLSet m_dbPropLSet;
    public IDBID my_GID = null;
    private ReifCacheMap m_reifCache;
    public PSet_ReifStore_RDB m_reif;

    SpecializedGraphReifier_RDB(DBPropLSet lProp, IPSet pSet, Integer dbGraphID) {
        this.m_pset = (PSet_ReifStore_RDB)pSet;
        this.m_dbPropLSet = lProp;
        this.my_GID = new DBIDInt(dbGraphID);
        this.m_reifCache = new ReifCacheMap(1);
        this.m_reif = this.m_pset;
    }

    public SpecializedGraphReifier_RDB(IPSet pSet, Integer dbGraphID) {
        this.m_pset = (PSet_ReifStore_RDB)pSet;
        this.my_GID = new DBIDInt(dbGraphID);
        this.m_reifCache = new ReifCacheMap(1);
        this.m_reif = this.m_pset;
    }

    public void add(Node n, Triple t, SpecializedGraph.CompletionFlag complete) throws CannotReifyException {
        StmtMask same = new StmtMask();
        StmtMask diff = new StmtMask();
        ReifCache rs = this.m_reifCache.load(n, t, same, diff);
        if (rs == null) {
            this.m_reif.storeReifStmt(n, t, this.my_GID);
        } else if (diff.hasNada()) {
            boolean didUpdate = false;
            if (!same.hasSubj()) {
                Triple st = Triple.create(n, RDF.Nodes.subject, t.getSubject());
                this.m_reif.updateFrag(n, st, new StmtMask(st), this.my_GID);
                didUpdate = true;
            }
            if (!same.hasPred()) {
                Triple pt = Triple.create(n, RDF.Nodes.predicate, t.getPredicate());
                this.m_reif.updateFrag(n, pt, new StmtMask(pt), this.my_GID);
                didUpdate = true;
            }
            if (!same.hasObj()) {
                Triple ot = Triple.create(n, RDF.Nodes.object, t.getObject());
                this.m_reif.updateFrag(n, ot, new StmtMask(ot), this.my_GID);
                didUpdate = true;
            }
            if (!rs.mask.hasType()) {
                Triple tt = Triple.create(n, RDF.Nodes.type, RDF.Nodes.Statement);
                this.m_reif.updateFrag(n, tt, new StmtMask(tt), this.my_GID);
                didUpdate = true;
            }
            if (didUpdate) {
                this.fragCompact(n);
            }
            this.m_reifCache.flushAll();
        } else {
            if (rs.mask.isStmt()) {
                throw new AlreadyReifiedException(n);
            }
            throw new CannotReifyException(n);
        }
        complete.setDone();
    }

    public void delete(Node n, Triple t, SpecializedGraph.CompletionFlag complete) {
        this.m_reifCache.flushAll();
        this.m_reif.deleteReifStmt(n, t, this.my_GID);
        complete.setDone();
    }

    public boolean contains(Node n, Triple t, SpecializedGraph.CompletionFlag complete) {
        throw new JenaException("SpecializedGraphReifier.contains called");
    }

    public ExtendedIterator findReifiedNodes(Triple t, SpecializedGraph.CompletionFlag complete) {
        complete.setDone();
        return this.m_reif.findReifStmtURIByTriple(t, this.my_GID);
    }

    public Triple findReifiedTriple(Node n, SpecializedGraph.CompletionFlag complete) {
        ResultSetReifIterator it = this.m_reif.findReifStmt(n, true, this.my_GID, false);
        Triple res = null;
        if (it.hasNext()) {
            res = (Triple)it.next();
        }
        complete.setDone();
        return res;
    }

    public ExtendedIterator findReifiedTriples(Node n, SpecializedGraph.CompletionFlag complete) {
        complete.setDone();
        return this.m_reif.findReifStmt(n, false, this.my_GID, true);
    }

    public void add(Graph g, SpecializedGraph.CompletionFlag complete) {
        throw new AddDeniedException("sorry, not implemented");
    }

    public void add(Triple frag, SpecializedGraph.CompletionFlag complete) throws AlreadyReifiedException {
        StmtMask fragMask = new StmtMask(frag);
        if (fragMask.hasNada()) {
            return;
        }
        boolean fragHasType = fragMask.hasType();
        Node stmtURI = frag.getSubject();
        ReifCache cachedFrag = this.m_reifCache.load(stmtURI);
        if (cachedFrag == null) {
            this.m_reif.storeFrag(stmtURI, frag, fragMask, this.my_GID);
            complete.setDone();
        } else {
            StmtMask cachedMask = cachedFrag.getStmtMask();
            if (cachedMask.hasIntersect(fragMask)) {
                ResultSetReifIterator it;
                boolean dup;
                boolean bl = dup = fragHasType && cachedMask.hasType();
                if (!dup && !(dup = (it = this.m_reif.findFrag(stmtURI, frag, fragMask, this.my_GID)).hasNext())) {
                    if (cachedMask.isStmt()) {
                        throw new AlreadyReifiedException(frag.getSubject());
                    }
                    this.m_reif.storeFrag(stmtURI, frag, fragMask, this.my_GID);
                    this.m_reifCache.flush(cachedFrag);
                }
            } else if (cachedFrag.canMerge(fragMask)) {
                if (cachedFrag.canUpdate(fragMask)) {
                    this.m_reif.updateFrag(stmtURI, frag, fragMask, this.my_GID);
                    cachedFrag.update(fragMask);
                } else {
                    this.fragCompact(stmtURI);
                }
            } else {
                this.m_reif.storeFrag(stmtURI, frag, fragMask, this.my_GID);
            }
        }
        complete.setDone();
    }

    public void delete(Triple frag, SpecializedGraph.CompletionFlag complete) {
        StmtMask fragMask = new StmtMask(frag);
        if (fragMask.hasNada()) {
            return;
        }
        Node stmtURI = frag.getSubject();
        ResultSetReifIterator it = this.m_reif.findFrag(stmtURI, frag, fragMask, this.my_GID);
        if (it.hasNext()) {
            if (it.getFragCount() == 1) {
                this.m_reif.deleteFrag(frag, fragMask, this.my_GID);
                it.close();
            } else {
                this.m_reif.nullifyFrag(stmtURI, fragMask, this.my_GID);
                it.close();
                this.fragCompact(stmtURI);
            }
            ReifCache cachedFrag = this.m_reifCache.lookup(stmtURI);
            if (cachedFrag != null) {
                this.m_reifCache.flush(cachedFrag);
            }
        }
        complete.setDone();
    }

    protected void fragCompact(Node stmtURI) {
        ResultSetReifIterator itHasType = this.m_reif.findReifStmt(stmtURI, true, this.my_GID, false);
        if (itHasType.hasNext()) {
            Triple t = (Triple)itHasType.next();
            if (itHasType.hasNext()) {
                throw new JenaException("Multiple HasType fragments for URI");
            }
            StmtMask htMask = new StmtMask(t);
            itHasType.close();
            ResultSetReifIterator itFrag = this.m_reif.findReifStmt(stmtURI, false, this.my_GID, false);
            StmtMask upMask = new StmtMask();
            while (itFrag.hasNext()) {
                t = (Triple)itFrag.next();
                if (itFrag.getHasType()) continue;
                StmtMask fm = new StmtMask(this.rowToFrag(stmtURI, t));
                if (htMask.hasIntersect(fm)) break;
                this.m_reif.updateFrag(stmtURI, t, fm, this.my_GID);
                htMask.setMerge(fm);
                this.m_reif.deleteFrag(t, fm, this.my_GID);
            }
        }
    }

    protected Triple rowToFrag(Node stmtURI, Triple row) {
        Node pred = null;
        Node obj = null;
        int valCnt = 0;
        if (row.getSubject() != null) {
            obj = row.getSubject();
            pred = RDF.Nodes.subject;
            ++valCnt;
        }
        if (row.getPredicate() != null) {
            obj = row.getPredicate();
            pred = RDF.Nodes.predicate;
            ++valCnt;
        }
        if (row.getObject() != null) {
            obj = row.getObject();
            pred = RDF.Nodes.object;
            ++valCnt;
        }
        if (valCnt != 1) {
            throw new JenaException("Partially reified row must have exactly one value");
        }
        return Triple.create(stmtURI, pred, obj);
    }

    public void add(List triples, SpecializedGraph.CompletionFlag complete) {
        ArrayList remainingTriples = new ArrayList();
        for (int i = 0; i < triples.size(); ++i) {
            SpecializedGraph.CompletionFlag partialResult = this.newComplete();
            this.add((Triple)triples.get(i), partialResult);
            if (partialResult.isDone()) continue;
            remainingTriples.add(triples.get(i));
        }
        triples.clear();
        if (remainingTriples.isEmpty()) {
            complete.setDone();
        } else {
            triples.addAll(remainingTriples);
        }
    }

    public void delete(List triples, SpecializedGraph.CompletionFlag complete) {
        boolean result = true;
        Iterator it = triples.iterator();
        while (it.hasNext()) {
            SpecializedGraph.CompletionFlag partialResult = this.newComplete();
            this.delete((Triple)it.next(), partialResult);
            result = result && partialResult.isDone();
        }
        if (result) {
            complete.setDone();
        }
    }

    public int tripleCount() {
        ExtendedIterator it = this.find(null, null, null, this.newComplete());
        int count = 0;
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        it.close();
        return count;
    }

    public ExtendedIterator find(TripleMatch t, SpecializedGraph.CompletionFlag complete) {
        ResultSetReifIterator it = this.m_reif.findReifTripleMatch(t, this.my_GID);
        return it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Triple t, SpecializedGraph.CompletionFlag complete) {
        ExtendedIterator it = this.find(t, complete);
        try {
            boolean bl = it.hasNext();
            return bl;
        }
        finally {
            it.close();
        }
    }

    public void close() {
        this.m_reif.close();
    }

    public void clear() {
        this.m_reif.removeStatementsFromDB(this.my_GID);
    }

    static boolean isReifProp(Node_URI p) {
        return p.equals(RDF.Nodes.subject) || p.equals(RDF.Nodes.predicate) || p.equals(RDF.Nodes.object) || p.equals(RDF.Nodes.type);
    }

    public int getGraphId() {
        return ((DBIDInt)this.my_GID).getIntID();
    }

    public IPSet getPSet() {
        return this.m_pset;
    }

    public DBPropLSet getDBPropLSet() {
        return this.m_dbPropLSet;
    }

    public char subsumes(Triple pattern, int reifBehavior) {
        int res = 110;
        if (reifBehavior != 1) {
            return (char)res;
        }
        Node pred = pattern.getPredicate();
        if (pred.isConcrete()) {
            if (pred.equals(RDF.Nodes.subject) || pred.equals(RDF.Nodes.predicate) || pred.equals(RDF.Nodes.object)) {
                res = 97;
            } else if (pred.equals(RDF.Nodes.type)) {
                Node obj = pattern.getObject();
                if (obj.equals(RDF.Nodes.Statement)) {
                    res = 97;
                } else if (!obj.isConcrete()) {
                    res = 115;
                }
            }
        } else if (pred.isVariable() || pred.equals(Node.ANY)) {
            res = 115;
        } else {
            throw new JenaException("Unexpected predicate: " + pred.toString());
        }
        return (char)res;
    }

    class StmtMask {
        protected int mask = 0;
        public static final int HasSubj = 1;
        public static final int HasPred = 2;
        public static final int HasObj = 4;
        public static final int HasType = 8;
        public static final int HasSPOT = 15;
        public static final int IsStmt = 16;
        public static final int HasNada = 0;

        public boolean hasSubj() {
            return (this.mask & 1) == 1;
        }

        public boolean hasPred() {
            return (this.mask & 2) == 2;
        }

        public boolean hasObj() {
            return (this.mask & 4) == 4;
        }

        public boolean hasType() {
            return (this.mask & 8) == 8;
        }

        public boolean hasSPOT() {
            return (this.mask & 0xF) == 15;
        }

        public boolean isStmt() {
            return (this.mask & 0x10) == 16;
        }

        public boolean hasNada() {
            return this.mask == 0;
        }

        public boolean hasOneBit() {
            return this.mask == 1 || this.mask == 2 || this.mask == 4 || this.mask == 8;
        }

        StmtMask(Triple t) {
            Node p = t.getPredicate();
            if (p != null) {
                Node o;
                if (p.equals(RDF.Nodes.subject)) {
                    this.mask = 1;
                } else if (p.equals(RDF.Nodes.predicate)) {
                    this.mask = 2;
                } else if (p.equals(RDF.Nodes.object)) {
                    this.mask = 4;
                } else if (p.equals(RDF.Nodes.type) && (o = t.getObject()).equals(RDF.Nodes.Statement)) {
                    this.mask = 8;
                }
            }
        }

        StmtMask() {
        }

        public void setMerge(StmtMask m) {
            this.mask |= m.mask;
        }

        public void setHasType() {
            this.mask |= 8;
        }

        public void setMask(boolean hasSubj, boolean hasProp, boolean hasObj, boolean hasType) {
            if (hasSubj) {
                this.mask |= 1;
            }
            if (hasProp) {
                this.mask |= 2;
            }
            if (hasObj) {
                this.mask |= 4;
            }
            if (hasType) {
                this.mask |= 8;
            }
        }

        public void setHasSubj() {
            this.mask |= 1;
        }

        public void setHasPred() {
            this.mask |= 2;
        }

        public void setHasObj() {
            this.mask |= 4;
        }

        public void setIsStmt() {
            this.mask |= 0x10;
        }

        public boolean hasIntersect(StmtMask m) {
            return (this.mask & m.mask) != 0;
        }

        public boolean equals(StmtMask m) {
            return this.mask == m.mask;
        }
    }

    class ReifCache {
        protected Node stmtURI;
        protected StmtMask mask;
        protected int tripleCnt;

        ReifCache(Node s, StmtMask m, int cnt) {
            this.stmtURI = s;
            this.mask = m;
            this.tripleCnt = cnt;
        }

        public StmtMask getStmtMask() {
            return this.mask;
        }

        public int getCnt() {
            return this.tripleCnt;
        }

        public Node getStmtURI() {
            return this.stmtURI;
        }

        public void setMask(StmtMask m) {
            this.mask = m;
        }

        public void setCnt(int cnt) {
            this.tripleCnt = cnt;
        }

        public void incCnt(int cnt) {
            ++this.tripleCnt;
        }

        public void decCnt(int cnt) {
            --this.tripleCnt;
        }

        public boolean canMerge(StmtMask fragMask) {
            return !this.mask.hasIntersect(fragMask);
        }

        public boolean canUpdate(StmtMask fragMask) {
            return this.canMerge(fragMask) && this.tripleCnt == 1;
        }

        public void update(StmtMask fragMask) {
            this.mask.setMerge(fragMask);
            if (this.isStmt()) {
                this.mask.setIsStmt();
            }
        }

        private boolean isStmt() {
            return this.mask.hasSPOT() && this.tripleCnt == 1;
        }
    }

    public class ReifCacheMap {
        protected int cacheSize = 1;
        protected ReifCache[] cache;
        protected boolean[] inUse;

        ReifCacheMap(int size) {
            this.inUse = new boolean[size];
            this.cache = new ReifCache[size];
            for (int i = 0; i < size; ++i) {
                this.inUse[i] = false;
            }
        }

        ReifCache lookup(Node stmtURI) {
            for (int i = 0; i < this.cache.length; ++i) {
                if (!this.inUse[i] || !this.cache[i].getStmtURI().equals(stmtURI)) continue;
                return this.cache[i];
            }
            return null;
        }

        public void flushAll() {
            for (int i = 0; i < this.cache.length; ++i) {
                this.inUse[i] = false;
            }
        }

        public void flush(ReifCache entry) {
            this.flushAll();
        }

        public ReifCache load(Node stmtURI) {
            ReifCache entry = this.lookup(stmtURI);
            if (entry != null) {
                return entry;
            }
            return this.load(stmtURI, null, null, null);
        }

        public ReifCache load(Node stmtURI, Triple s, StmtMask sm, StmtMask dm) {
            this.flushAll();
            StmtMask m = new StmtMask();
            boolean checkSame = sm != null;
            int cnt = 0;
            ResultSetReifIterator it = SpecializedGraphReifier_RDB.this.m_reif.findReifStmt(stmtURI, false, SpecializedGraphReifier_RDB.this.my_GID, false);
            while (it.hasNext()) {
                boolean hasObj;
                boolean hasPred;
                boolean hasSubj;
                ++cnt;
                Triple db = (Triple)it.next();
                StmtMask n = new StmtMask();
                boolean bl = hasSubj = !db.getSubject().equals(Node.NULL);
                if (hasSubj && checkSame) {
                    if (db.getSubject().equals(s.getSubject())) {
                        sm.setHasSubj();
                    } else {
                        dm.setHasSubj();
                    }
                }
                boolean bl2 = hasPred = !db.getPredicate().equals(Node.NULL);
                if (hasPred && checkSame) {
                    if (db.getPredicate().equals(s.getPredicate())) {
                        sm.setHasPred();
                    } else {
                        dm.setHasPred();
                    }
                }
                boolean bl3 = hasObj = !db.getObject().equals(Node.NULL);
                if (hasObj && checkSame) {
                    if (db.getObject().equals(s.getObject())) {
                        sm.setHasObj();
                    } else {
                        dm.setHasObj();
                    }
                }
                boolean hasType = it.getHasType();
                n.setMask(hasSubj, hasPred, hasObj, hasType);
                if (n.hasNada()) {
                    throw new JenaException("Fragment has no data");
                }
                m.setMerge(n);
            }
            if (cnt == 0) {
                return null;
            }
            if (m.hasSPOT() && cnt == 1) {
                m.setIsStmt();
            }
            this.inUse[0] = true;
            this.cache[0] = new ReifCache(stmtURI, m, cnt);
            return this.cache[0];
        }
    }
}

