/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.impl.StateFlag;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.BRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.GoalState;
import java.util.Iterator;

public class TopGoalIterator
implements Iterator {
    GoalState goalState;
    Object lookAhead;
    BRuleEngine engine;

    public TopGoalIterator(BRuleEngine engine, TriplePattern goal) {
        this.engine = engine;
        this.goalState = engine.findGoal(goal);
        this.moveForward();
    }

    private void moveForward() {
        this.lookAhead = this.goalState.next();
        if (this.lookAhead == StateFlag.SUSPEND) {
            this.lookAhead = this.engine.next(this.goalState) != null ? this.goalState.next() : null;
        } else if (this.lookAhead == StateFlag.FAIL) {
            this.lookAhead = null;
        }
        if (this.lookAhead == null) {
            this.close();
        }
    }

    public void close() {
        this.goalState.close();
        this.engine.halt();
    }

    public boolean hasNext() {
        return this.lookAhead != null;
    }

    public Object next() {
        Object result = this.lookAhead;
        this.moveForward();
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

