% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ClusterSystem.R
\encoding{UTF-8}
\name{create_ClusterSystem}
\alias{create_ClusterSystem}
\title{Create dosimetric cluster system}
\usage{
create_ClusterSystem(n = 100, h = 0.5, plot = FALSE, ...)
}
\arguments{
\item{n}{\link{numeric} (\emph{with default}): number of clusters to be created
in an arbitrary 3-dimensional cube. x, y, z  distances range between 0 and 1.}

\item{h}{\link{numeric} (\emph{with default}): numeric scalar the cut the cluster tree
using \link[stats:cutree]{stats::cutree}. The number must range between 0 and 1.}

\item{plot}{\link{logical} (\emph{with default}): enables/disables plot output}

\item{...}{further arguments to be passed to the plot output}
}
\value{
The function returns a \link{list} of class \code{RLumCarlo_clusters} consisting
of \link{numeric} vector of cluster groups and a \link{matrix} of the cluster positions
in the arbitrary space. If \code{plot = TRUE} the system is displayed using
\link[scatterplot3d:scatterplot3d]{scatterplot3d::scatterplot3d}
}
\description{
In order to allow interaction of an spatial a correlation clusters
in RLumCarlo, first a dosimetric system needs to be created in a three-dimensional space,
which is the purpose of this function.
}
\section{Function version}{
 0.1.0
}

\examples{
create_ClusterSystem(n = 10, plot = TRUE)

}
\seealso{
\link[stats:dist]{stats::dist}, \link[stats:hclust]{stats::hclust}, \link[stats:cutree]{stats::cutree}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
} 

\section{How to cite}{
Kreutzer, S., 2020. create_ClusterSystem(): Create dosimetric cluster system. Function version 0.1.0. In: Friedrich, J., Kreutzer, S., Pagonis, V., Schmidt, C., 2020. RLumCarlo: Monte-Carlo Methods for Simulating Luminescence Phenomena. R package version 0.1.7. https://CRAN.R-project.org/package=RLumCarlo
}

\keyword{data}
\keyword{models}
