% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grammpred.R
\name{grammpred}
\alias{grammpred}
\title{Gramm Matrix for Test dataset}
\usage{
grammpred(xtrain, xtest, kernel, sigma, degree, scale)
}
\arguments{
\item{xtrain}{Matrix of predictors for the training set}

\item{xtest}{Matrix of predictors for the test set}

\item{kernel}{Type of kernel used to compute a gramm matrix}

\item{sigma}{Hyperparameters for radial kernels}

\item{degree, scale}{Hyperparameter for polynomial kernel}
}
\value{
Gramm matrix for test set
}
\description{
This function creates gramm matrix for test dataset based upon several types of kernel.
}
\examples{
library(kernlab)
data(benchmark.data)
example.data=benchmark.data[[1]]
#Create split between training samples and test samples
training.samples=sample(1:dim(example.data)[1],floor(0.7*dim(example.data)[1]),replace=FALSE)
xtrain=example.data[training.samples,1:2]
xtest=example.data[-training.samples,1:2]
#Generate linear kernel
grammpred(xtrain,xtest,'linear',0,0,0)
#Generate radial kernels with different values for the hyperparameter.
grammpred(xtrain,xtest,'radial',2^seq(-3:0),0,0)
}
