% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{trainMOA.MOA_recommender}
\alias{trainMOA.MOA_recommender}
\title{Train a MOA recommender (e.g. a BRISMFPredictor) on a datastream}
\usage{
\method{trainMOA}{MOA_recommender}(model, formula, data, subset,
  na.action = na.exclude, transFUN = identity, chunksize = 1000,
  trace = FALSE, options = list(maxruntime = +Inf), ...)
}
\arguments{
\item{model}{an object of class \code{MOA_model}, as returned by \code{\link{MOA_recommender}}, e.g.
a \code{\link{BRISMFPredictor}}}

\item{formula}{a symbolic description of the model to be fit. This should be of the form rating ~ userid + itemid, in that sequence.
These should be columns in the \code{data}, where userid and itemid are integers and rating is numeric.}

\item{data}{an object of class \code{\link{datastream}} set up e.g. with \code{\link{datastream_file}}, 
\code{\link{datastream_dataframe}}, \code{\link{datastream_matrix}}, \code{\link{datastream_ffdf}} or your own datastream.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data contain \code{NA}s. 
See \code{\link{model.frame}} for details. Defaults to \code{\link{na.exclude}}.}

\item{transFUN}{a function which is used after obtaining \code{chunksize} number of rows 
from the \code{data} datastream before applying \code{\link{model.frame}}. Useful if you want to 
change the results \code{get_points} on the datastream 
(e.g. for making sure the factor levels are the same in each chunk of processing, some data cleaning, ...). 
Defaults to \code{\link{identity}}.}

\item{chunksize}{the number of rows to obtain from the \code{data} datastream in one chunk of model processing.
Defaults to 1000. Can be used to speed up things according to the backbone architecture of
the datastream.}

\item{trace}{logical, indicating to show information on how many datastream chunks are already processed
as a \code{message}.}

\item{options}{a names list of further options. Currently not used.}

\item{...}{other arguments, currently not used yet}
}
\value{
An object of class MOA_trainedmodel which is a list with elements
\itemize{
\item{model: the updated supplied \code{model} object of class \code{MOA_recommender}}
\item{call: the matched call}
\item{na.action: the value of na.action}
\item{terms: the \code{terms} in the model}
\item{transFUN: the transFUN argument}
}
}
\description{
Train a MOA recommender (e.g. a BRISMFPredictor) on a datastream
}
\examples{
require(recommenderlab)
data(MovieLense)
x <- getData.frame(MovieLense)
x$itemid <- as.integer(as.factor(x$item))
x$userid <- as.integer(as.factor(x$user))
x$rating <- as.numeric(x$rating)
x <- head(x, 5000)

movielensestream <- datastream_dataframe(data=x)
movielensestream$get_points(3)

ctrl <- MOAoptions(model = "BRISMFPredictor", features = 10)
brism <- BRISMFPredictor(control=ctrl)
mymodel <- trainMOA(model = brism, rating ~ userid + itemid, 
 data = movielensestream, chunksize = 1000, trace=TRUE)
summary(mymodel$model)
}
\seealso{
\code{\link{MOA_recommender}}, \code{\link{datastream_file}}, \code{\link{datastream_dataframe}}, 
\code{\link{datastream_matrix}}, \code{\link{datastream_ffdf}}, \code{\link{datastream}},
\code{\link{predict.MOA_trainedmodel}}
}
