% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{RMPSolveS}
\alias{RMPSolveS}
\title{Recursive Modified Pattern Search on Simplex}
\arguments{
\item{x0}{Vector of Initial Guess provided by User.}

\item{func}{The Function to be Optimized, should be provided by the User.}

\item{s_init}{Initial  'Global Step Size'. Default Value is 2. It must be set Less than or Equal to 2.}

\item{rho_1}{'Step Decay Rate' for the First Run Only (Default is 2).}

\item{rho_2}{'Step Decay Rate' for Second Run Onwards (Default is 2).}

\item{phi}{Lower Bound for 'Global Step Size'. Default value is \eqn{10^{-6}}.}

\item{max_iter}{Max Number of Iterations in each 'Run'. Default Value is 10000.}

\item{no_runs}{Max Number of 'Runs'. Default Value is \eqn{10^{-6}}.}

\item{lambda}{Sparsity Control Parameter. Default Value is \eqn{10^{-10}}.}

\item{tol_fun}{Termination Tolerance on when to decrease the 'Global Step Size'. Default Value is \eqn{10^{-6}}. For more accuracy, user may set it to a Smaller Value
e.g., \eqn{10^{-20}}. However, for Expensive Objective Functions, for Faster Computation, User should set it to a Larger Value e.g, \eqn{10^{-3}}.}

\item{tol_fun_2}{Termination Tolerance on the Difference of Norms of solution points in two Consecutive Runs. Default Value is \eqn{10^{-20}}.
However, for Expensive Objective Functions, for Faster Computation, user should set it to a Larger Value e.g, \eqn{10^{-6}}.}

\item{print_output}{Binary Command to Print Optimized Value of Objective Function after Each Iteration. Default is set as FALSE.}
}
\value{
The Optimal Solution Point.
}
\description{
'RMPSolveS' can be used to maximize any function where the set of parameters belong to an unit simplex.
}
\examples{

g <- function(y)
return(-20 * exp(-0.2 * sqrt(0.5 * (y[1] ^ 2 + (y[2]-1) ^ 2)))
         - exp(0.5 * (cos(2 * pi * y[1]) + cos(2 * pi * (y[2]-1))))
         + exp(1) + 20)
         
# global min value is 0, achieved at c(0,1)

starting_point <- c(0.4,0.6)
         
g(starting_point)
solution <- RMPSolveS(starting_point, g)
g(solution)
           
# Example of putting infeasible starting point

g <- function(y)
return(-y[1])   # min value is 1, achieved if first coordinate is 1
             
RMPSolveS(c(1,0.2,56,0.4),g) # starting point NOT on simplex
               
\donttest{               
# Example of 1000 dimensional problem
g <- function(y)
return(- sum(y^10))
                 
# min value is -1, achieved if only one
# coordinate is equal to 1, rest are 0

RMPSolveS(rep(1 / 1000, 1000), g, print = 1)
}


}
\references{
\itemize{

  \item Das, Priyam \cr
   "Recursive Modified Pattern Search on High-dimensional Simplex : A Blackbox Optimization Technique" \cr
         (available at `arXiv \url{http://arxiv.org/abs/1604.08636}).
}
}
