/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.parsing;

import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IndexedSeqOptimized$class;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce$class;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.xml.parsing.TokenTests;

public abstract class TokenTests$class {
    public static final boolean isSpace(TokenTests $this, char ch) {
        boolean bl;
        char c = ch;
        switch (c) {
            default: {
                bl = false;
                break;
            }
            case '\t': {
                bl = true;
                break;
            }
            case ' ': {
                bl = true;
                break;
            }
            case '\r': {
                bl = true;
                break;
            }
            case '\n': {
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean isSpace(TokenTests $this, Seq cs) {
        return cs.nonEmpty() && cs.forall(new Serializable($this){
            public static final long serialVersionUID;
            public final TokenTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(char c) {
                return this.$outer.isSpace(c);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static boolean isAlpha(TokenTests $this, char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isAlphaDigit(TokenTests $this, char c) {
        return $this.isAlpha(c) || c >= '0' && c <= '9';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNameChar(TokenTests $this, char ch) {
        boolean bl;
        if ($this.isNameStart(ch)) return true;
        byte by2 = (byte)Character.getType(ch);
        switch (by2) {
            default: {
                bl = Predef$.MODULE$.augmentString(".-:").contains(BoxesRunTime.boxToCharacter(ch));
                break;
            }
            case 4: {
                return true;
            }
            case 8: {
                return true;
            }
            case 7: {
                return true;
            }
            case 9: {
                return true;
            }
            case 6: {
                return true;
            }
        }
        if (!bl) return false;
        return true;
    }

    public static boolean isNameStart(TokenTests $this, char ch) {
        boolean bl;
        byte by2 = (byte)Character.getType(ch);
        switch (by2) {
            default: {
                if (ch == '_') {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            case 10: {
                bl = true;
                break;
            }
            case 5: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isName(TokenTests $this, String s) {
        String string;
        String string2;
        String string3 = s;
        return TraversableOnce$class.nonEmpty(new StringOps(string3)) && $this.isNameStart(BoxesRunTime.unboxToChar(IndexedSeqOptimized$class.head(new StringOps(string2 = s)))) && IndexedSeqOptimized$class.forall(Predef$.MODULE$.augmentString((String)IndexedSeqOptimized$class.tail(new StringOps(string = s))), (Function1)((Object)new Serializable($this){
            public static final long serialVersionUID;
            public final TokenTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(char c) {
                return this.$outer.isNameChar(c);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    public static boolean isPubIDChar(TokenTests $this, char ch) {
        return $this.isAlphaDigit(ch) || $this.isSpace(ch) && ch != '\t' || Predef$.MODULE$.augmentString("-\\()+,./:=?;!*#@$_%").contains(BoxesRunTime.boxToCharacter(ch));
    }

    public static boolean isValidIANAEncoding(TokenTests $this, Seq ianaEncoding) {
        return ianaEncoding.nonEmpty() && $this.isAlpha(BoxesRunTime.unboxToChar(ianaEncoding.head())) && ((IterableLike)ianaEncoding.tail()).forall(new Serializable($this){
            public static final long serialVersionUID;
            public final TokenTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(char c) {
                return TokenTests$class.charOK$1(this.$outer, c);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static boolean checkSysID(TokenTests $this, String s$1) {
        return List$.MODULE$.apply(Predef$.MODULE$.wrapCharArray(new char[]{'\"', '\''})).exists(new Serializable($this, s$1){
            public static final long serialVersionUID;
            public final String s$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(char c) {
                return !Predef$.MODULE$.augmentString(this.s$1).contains(BoxesRunTime.boxToCharacter(c));
            }
            {
                this.s$1 = string;
            }
        });
    }

    public static boolean checkPubID(TokenTests $this, String s) {
        String string = s;
        return IndexedSeqOptimized$class.forall(new StringOps(string), (Function1)((Object)new Serializable($this){
            public static final long serialVersionUID;
            public final TokenTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(char c) {
                return this.$outer.isPubIDChar(c);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    public static final boolean charOK$1(TokenTests $this, char c) {
        return $this.isAlphaDigit(c) || Predef$.MODULE$.augmentString("._-").contains(BoxesRunTime.boxToCharacter(c));
    }

    public static void $init$(TokenTests $this) {
    }
}

