% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts_statistics.R
\name{plot_total_counts}
\alias{plot_total_counts}
\title{Plot total counts per sample}
\usage{
plot_total_counts(dds, n_bins = 50)
}
\arguments{
\item{dds}{A DESeqDataSet}

\item{n_bins}{Number of histogram bins}
}
\value{
A ggplot object of the ggplot2 package that contains the histogram of total counts per sample.
}
\description{
Plot the distribution of the total number of counts per sample as histogram.
}
\examples{
library("DESeq2")
set.seed(1)
dds <- makeExampleDESeqDataSet(m=30)
plot_total_counts(dds)

}
