% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti.R
\name{writeNifti}
\alias{writeNifti}
\alias{writeAnalyze}
\title{Write a NIfTI or ANALYZE format file}
\usage{
writeNifti(image, file, template = NULL, datatype = "auto", version = 1,
  compression = 6)

writeAnalyze(image, file, template = NULL, datatype = "auto",
  compression = 6)
}
\arguments{
\item{image}{An image, in any acceptable form (see \code{\link{asNifti}}).}

\item{file}{A character string containing a file name. If this has no file
extension suffix, or ends with \code{"nii"}, the single-file NIfTI format
is used; if the suffix is \code{"nii.gz"}, the compressed single-file
format is used; if the suffix is \code{"hdr"} or \code{"img"}, the NIfTI
pair two-file format is used; if it's \code{"hdr.gz"} or \code{"img.gz"},
the compressed pair format is used. If any other extension is present it
will be ignored, and \code{".nii"} appended.}

\item{template}{An optional template object to derive NIfTI properties
from. Passed to \code{\link{asNifti}} if \code{image} is an array.}

\item{datatype}{The NIfTI datatype to use when writing the data out. The
default, \code{"auto"} uses the R type or, for internal images, the
original datatype. Other possibilities are \code{"float"}, \code{"int16"},
etc., which may be preferred to reduce file size. However, no checks are
done to ensure that the coercion maintains precision.}

\item{version}{An integer (1 or 2) giving the NIfTI file format version to
use. Version 2 is usually only needed for very large images or where
metadata needs to be stored with high precision. The types available for
storing the pixel data are the same in both cases.}

\item{compression}{The gzip compression level to use, an integer between 0
(none) and 9 (maximum). Ignored if an uncompressed format is implied by
the requested file name.}
}
\value{
An invisible, named character vector giving the image and header
  file names written to.
}
\description{
These functions write an image to NIfTI-1, NIfTI-2 or ANALYZE-7.5 format,
using the standard NIfTI C library.
}
\note{
The ANALYZE-7.5 file format is a legacy format and use of it is not
  recommended, except for compatibility. In particular, the format does
  not reliably specify the spatial orientation of the image.
}
\examples{
\dontrun{writeNifti(im, "image.nii.gz", datatype="float")}

}
\references{
The NIfTI-1 standard (\url{https://www.nitrc.org/docman/view.php/26/64/nifti1.h}).
}
\seealso{
\code{\link{readNifti}}, \code{\link{asNifti}}
}
\author{
Jon Clayden <code@clayden.org>
}
