% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niftyreg.R
\name{niftyreg}
\alias{as.array.niftyreg}
\alias{niftyreg}
\title{Two and three dimensional image registration}
\usage{
niftyreg(source, target, scope = c("affine", "rigid", "nonlinear"),
  init = NULL, sourceMask = NULL, targetMask = NULL, symmetric = TRUE,
  interpolation = 3L, estimateOnly = FALSE, sequentialInit = FALSE,
  internal = NA, ...)

\method{as.array}{niftyreg}(x, ...)
}
\arguments{
\item{source}{The source image, an object of class \code{"nifti"} or
\code{"internalImage"}, or a plain array, or a NIfTI-1 filename. Must have
2, 3 or 4 dimensions.}

\item{target}{The target image, an object of class \code{"nifti"} or
\code{"internalImage"}, or a plain array, or a NIfTI-1 filename. Must have
2 or 3 dimensions.}

\item{scope}{A string describing the scope, or number of degrees of freedom
(DOF), of the registration. The currently supported values are
\code{"affine"} (12 DOF), \code{"rigid"} (6 DOF) or \code{"nonlinear"}
(high DOF, with the exact number depending on the image sizes).}

\item{init}{Transformation(s) to be used for initialisation, which may be
\code{NULL}, for no initialisation, or an affine matrix or control point
image (nonlinear only). For multiple registration, where the source image
has one more dimension than the target, this may also be a list whose
components are likewise \code{NULL} or a suitable initial transform.}

\item{sourceMask}{An optional mask image in source space, whose nonzero
region will be taken as the region of interest for the registration.
Ignored when \code{symmetric} is \code{FALSE}.}

\item{targetMask}{An optional mask image in target space, whose nonzero
region will be taken as the region of interest for the registration.}

\item{symmetric}{Logical value. Should forward and reverse transformations
be estimated simultaneously?}

\item{interpolation}{A single integer specifying the type of interpolation
to be applied to the final resampled image. May be 0 (nearest neighbour),
1 (trilinear) or 3 (cubic spline). No other values are valid.}

\item{estimateOnly}{Logical value: if \code{TRUE}, transformations will be
estimated, but images will not be resampled.}

\item{sequentialInit}{If \code{TRUE} and \code{source} has higher
dimensionality than \code{target}, transformations which are not
explicitly initialised will begin from the result of the previous
registration.}

\item{internal}{If \code{NA}, the default, the final resampled image will be
returned as a standard R array, but control point maps will be objects of
class \code{"internalImage"}, containing only basic metadata and a C-level
pointer to the full image. (See also \code{\link{readNifti}}.) If
\code{TRUE}, all image-type objects in the result will be internal images;
if \code{FALSE}, they will all be R arrays. The default is fine for most
purposes, but using \code{TRUE} may save memory, while using \code{FALSE}
can be necessary if there is a chance that external pointers will be
invalidated, for example when returning from worker threads.}

\item{...}{Further arguments to \code{\link{niftyreg.linear}} or
\code{\link{niftyreg.nonlinear}}.}

\item{x}{A \code{"niftyreg"} object.}
}
\value{
A list of class \code{"niftyreg"} with components:
  \describe{
    \item{image}{An array or internal image representing the registered and
      resampled \code{source} image in the space of the \code{target} image.
      This element is \code{NULL} if the \code{estimateOnly} parameter is
      \code{TRUE}.}
    \item{forwardTransforms}{A list of (linear or nonlinear) transformations
      from source to target space.}
    \item{reverseTransforms}{A list of (linear or nonlinear) transformations
      from target to source space.}
    \item{iterations}{A list of integer vectors, giving the number of
      iterations completed at each ``level'' of the algorithm. Note that for
      the first level of the linear algorithm specifically, twice the
      specified number of iterations is allowed.}
    \item{source}{An internal representation of the source image for each
      registration.}
    \item{target}{An internal representation of the target image.}
  }
  The \code{as.array} method for this class returns the \code{image}
  element.
}
\description{
The \code{niftyreg} function performs linear or nonlinear registration for
two and three dimensional images. 4D images may also be registered
volumewise to a 3D image, or 3D images slicewise to a 2D image. This
function is a common wrapper for \code{\link{niftyreg.linear}} and
\code{\link{niftyreg.nonlinear}}.
}
\note{
If substantial parts of the target image are zero-valued, for example
  because the target image has been brain-extracted, it can be useful to
  pass it as a target mask as well as the target image, viz.
  \code{niftyreg(source, target, targetMask=target)}.
}
\examples{
\dontrun{
source <- readNifti(system.file("extdata", "epi_t2.nii.gz",
  package="RNiftyReg"))
target <- readNifti(system.file("extdata", "flash_t1.nii.gz",
  package="RNiftyReg"))

result <- niftyreg(source, target, scope="affine")
}

}
\author{
Jon Clayden <code@clayden.org>
}
\references{
Please see \code{\link{niftyreg.linear}} or
\code{\link{niftyreg.nonlinear}} for references relating to each type of
registration.
}
\seealso{
\code{\link{niftyreg.linear}} and \code{\link{niftyreg.nonlinear}},
  which do most of the work. Also, \code{\link{forward}} and
  \code{\link{reverse}} to extract transformations, and
  \code{\link{applyTransform}} to apply them to new images or points.
}

