% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niftyreg.R
\name{niftyreg.nonlinear}
\alias{niftyreg.nonlinear}
\title{Two and three dimensional nonlinear image registration}
\usage{
niftyreg.nonlinear(source, target, init = NULL, sourceMask = NULL,
  targetMask = NULL, symmetric = TRUE, nLevels = 3L,
  maxIterations = 150L, nBins = 64L, bendingEnergyWeight = 0.001,
  linearEnergyWeight = 0.01, jacobianWeight = 0, finalSpacing = c(5, 5,
  5), spacingUnit = c("voxel", "world"), interpolation = 3L,
  verbose = FALSE, estimateOnly = FALSE, sequentialInit = FALSE,
  internal = NA, precision = c("double", "single"))
}
\arguments{
\item{source}{The source image, an object of class \code{"nifti"} or
\code{"internalImage"}, or a plain array, or a NIfTI-1 filename. Must have
2, 3 or 4 dimensions.}

\item{target}{The target image, an object of class \code{"nifti"} or
\code{"internalImage"}, or a plain array, or a NIfTI-1 filename. Must have
2 or 3 dimensions.}

\item{init}{Transformation(s) to be used for initialisation, which may be
\code{NULL}, for no initialisation, or an affine matrix or control point
image (nonlinear only). For multiple registration, where the source image
has one more dimension than the target, this may also be a list whose
components are likewise \code{NULL} or a suitable initial transform.}

\item{sourceMask}{An optional mask image in source space, whose nonzero
region will be taken as the region of interest for the registration.
Ignored when \code{symmetric} is \code{FALSE}.}

\item{targetMask}{An optional mask image in target space, whose nonzero
region will be taken as the region of interest for the registration.}

\item{symmetric}{Logical value. Should forward and reverse transformations
be estimated simultaneously?}

\item{nLevels}{A single integer specifying the number of levels of the
algorithm that should be applied. If zero, no optimisation will be
performed, and the final control-point image will be the same as its
initialisation value.}

\item{maxIterations}{A single integer specifying the maximum number of
iterations to be used within each level. Fewer iterations may be used if a
convergence test deems the process to have completed.}

\item{nBins}{A single integer giving the number of bins to use for the joint
histogram created by the algorithm.}

\item{bendingEnergyWeight}{A numeric value giving the weight of the bending
energy term in the cost function.}

\item{linearEnergyWeight}{A numeric value giving the weight of the linear
energy term in the cost function.}

\item{jacobianWeight}{A numeric value giving the weight of the Jacobian
determinant term in the cost function.}

\item{finalSpacing}{A numeric vector giving the spacing of control points in
the final grid, along the X, Y and Z directions respectively. This is set
from the initial control point image, if one is supplied.}

\item{spacingUnit}{A character string giving the units in which the
\code{finalSpacing} is specified: either \code{"voxel"} for pixels/voxels,
or \code{"world"} for real-world units (see \code{\link{pixunits}}).}

\item{interpolation}{A single integer specifying the type of interpolation
to be applied to the final resampled image. May be 0 (nearest neighbour),
1 (trilinear) or 3 (cubic spline). No other values are valid.}

\item{verbose}{A single logical value: if \code{TRUE}, the code will give
some feedback on its progress; otherwise, nothing will be output while the
algorithm runs. Run time can be seconds or more, depending on the size and
dimensionality of the images.}

\item{estimateOnly}{Logical value: if \code{TRUE}, transformations will be
estimated, but images will not be resampled.}

\item{sequentialInit}{If \code{TRUE} and \code{source} has higher
dimensionality than \code{target}, transformations which are not
explicitly initialised will begin from the result of the previous
registration.}

\item{internal}{If \code{NA}, the default, the final resampled image will be
returned as a standard R array, but control point maps will be objects of
class \code{"internalImage"}, containing only basic metadata and a C-level
pointer to the full image. (See also \code{\link{readNifti}}.) If
\code{TRUE}, all image-type objects in the result will be internal images;
if \code{FALSE}, they will all be R arrays. The default is fine for most
purposes, but using \code{TRUE} may save memory, while using \code{FALSE}
can be necessary if there is a chance that external pointers will be
invalidated, for example when returning from worker threads.}

\item{precision}{Working precision for the registration. Using single-
precision may be desirable to save memory when coregistering large images.}
}
\value{
See \code{\link{niftyreg}}.
}
\description{
The \code{niftyreg.nonlinear} function performs nonlinear registration for
two and three dimensional images. 4D images may also be registered
volumewise to a 3D image, or 3D images slicewise to a 2D image. The warping
is based on free-form deformations, parameterised using an image of control
points.
}
\details{
This function performs the dual operations of finding a transformation to
optimise image alignment, and resampling the source image into the space of
the target image (and vice-versa, if \code{symmetric} is \code{TRUE}).
Unlike \code{\link{niftyreg.linear}}, this transformation is nonlinear, and
the degree of deformation may vary across the image.

The nonlinear warping is based on free-form deformations. A lattice of
equally-spaced control points is defined over the target image, each of
which can be moved to locally modify the mapping to the source image. In
order to assess the quality of the warping between the two images, an
objective function based on the normalised mutual information is used, with
penalty terms based on the bending energy or the squared log of the Jacobian
determinant. The objective function value is optimised using a conjugate
gradient scheme.

The source image may have 2, 3 or 4 dimensions, and the target 2 or 3. The
dimensionality of the target image determines whether 2D or 3D registration
is applied, and source images with one more dimension than the target (i.e.
4D to 3D, or 3D to 2D) will be registered volumewise or slicewise, as
appropriate. In the latter case the last dimension of the resulting image is
taken from the source image, while all other dimensions come from the
target. One image of control points is returned for each registration
performed.
}
\note{
Performing a linear registration first, and then initialising the
  nonlinear transformation with the result (via the \code{init} parameter),
  is highly recommended in most circumstances.
}
\references{
The algorithm used by this function is described in the
following publication.

M. Modat, G.R. Ridgway, Z.A. Taylor, M. Lehmann, J. Barnes, D.J. Hawkes,
N.C. Fox & S. Ourselin (2010). Fast free-form deformation using graphics
processing units. Computer Methods and Programs in Biomedicine
98(3):278-284.
}
\seealso{
\code{\link{niftyreg}}, which can be used as an interface to this
  function, and \code{\link{niftyreg.linear}} for linear registration. Also,
  \code{\link{forward}} and \code{\link{reverse}} to extract
  transformations, and \code{\link{applyTransform}} to apply them to new
  images or points.
}
\author{
Jon Clayden <code@clayden.org>
}
