% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niftyreg.R
\name{similarity}
\alias{similarity}
\title{Similarity measures between images}
\usage{
similarity(source, target, targetMask = NULL, interpolation = 3L,
  threads = getOption("RNiftyReg.threads"))
}
\arguments{
\item{source}{The source image, in any acceptable form.}

\item{target}{The target image. Must have the same dimensionality as the
source image.}

\item{targetMask}{An optional mask image in target space, whose nonzero
region will be the area over which the measure is calculated.}

\item{interpolation}{A single integer specifying the type of interpolation
to be applied to the source image when resampling it into the space of the
target image. May be 0 (nearest neighbour), 1 (trilinear) or 3 (cubic
spline). No other values are valid.}

\item{threads}{For OpenMP-capable builds of the package, the maximum number
of threads to use.}
}
\value{
A single numeric value representing the similarity between the
  images.
}
\description{
This function calculates a similarity measure between two images, after
resampling one into the space of the other. The only supported measure is
currently normalised mutual information, which is also used as a cost
function by the registration algorithms.
}
\seealso{
\code{\link{niftyreg}}
}
\author{
Jon Clayden <code@clayden.org>
}
