% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.rv_ratio_histogram.R
\name{rv_ratio_histogram}
\alias{rv_ratio_histogram}
\title{rv_ratio_histogram}
\description{
rv_ratio_histogram distribution in OOP way.
}
\details{
Fit separatly P( X < x | X > 0 ) and P(X=0)
}
\examples{
## Generate sample
X = numeric(10000)
X[1:2000] = 0
X[2001:10000] = stats::rexp( n = 8000 , rate = 1 )

## And fit it
rvX = rv_ratio_histogram$new()
rvX$fit( X , x0 = 0 )

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{rvXp}}{[ROOPSD::rv_histogram] Describes P(X < x | X > x0)}

\item{\code{x0}}{[double] location of mass: P( X = x0 )}

\item{\code{p0}}{[double] p0 = P( X = x0 )}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-rv_ratio_histogram-new}{\code{rv_ratio_histogram$new()}}
\item \href{#method-rv_ratio_histogram-rvs}{\code{rv_ratio_histogram$rvs()}}
\item \href{#method-rv_ratio_histogram-cdf}{\code{rv_ratio_histogram$cdf()}}
\item \href{#method-rv_ratio_histogram-icdf}{\code{rv_ratio_histogram$icdf()}}
\item \href{#method-rv_ratio_histogram-sf}{\code{rv_ratio_histogram$sf()}}
\item \href{#method-rv_ratio_histogram-isf}{\code{rv_ratio_histogram$isf()}}
\item \href{#method-rv_ratio_histogram-fit}{\code{rv_ratio_histogram$fit()}}
\item \href{#method-rv_ratio_histogram-clone}{\code{rv_ratio_histogram$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_ratio_histogram-new"></a>}}
\if{latex}{\out{\hypertarget{method-rv_ratio_histogram-new}{}}}
\subsection{Method \code{new()}}{
Create a new rv_ratio_histogram object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_ratio_histogram$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{If a param `Y` and `x0` is given, the fit method is called with `...`.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `rv_ratio_histogram` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_ratio_histogram-rvs"></a>}}
\if{latex}{\out{\hypertarget{method-rv_ratio_histogram-rvs}{}}}
\subsection{Method \code{rvs()}}{
Generation sample from the histogram
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_ratio_histogram$rvs(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{[integer] Number of samples drawn}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector of samples
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_ratio_histogram-cdf"></a>}}
\if{latex}{\out{\hypertarget{method-rv_ratio_histogram-cdf}{}}}
\subsection{Method \code{cdf()}}{
Cumulative Distribution Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_ratio_histogram$cdf(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{[vector] Quantiles to compute the CDF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
cdf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_ratio_histogram-icdf"></a>}}
\if{latex}{\out{\hypertarget{method-rv_ratio_histogram-icdf}{}}}
\subsection{Method \code{icdf()}}{
Inverse of Cumulative Distribution Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_ratio_histogram$icdf(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities to compute the CDF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
icdf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_ratio_histogram-sf"></a>}}
\if{latex}{\out{\hypertarget{method-rv_ratio_histogram-sf}{}}}
\subsection{Method \code{sf()}}{
Survival Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_ratio_histogram$sf(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{[vector] Quantiles to compute the SF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
sf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_ratio_histogram-isf"></a>}}
\if{latex}{\out{\hypertarget{method-rv_ratio_histogram-isf}{}}}
\subsection{Method \code{isf()}}{
Inverse of Survival Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_ratio_histogram$isf(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities to compute the SF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
isf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_ratio_histogram-fit"></a>}}
\if{latex}{\out{\hypertarget{method-rv_ratio_histogram-fit}{}}}
\subsection{Method \code{fit()}}{
Fit method for the histograms
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_ratio_histogram$fit(Y, x0, bins = as.integer(100))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y}}{[vector] Dataset to infer the histogram}

\item{\code{x0}}{[double] Location of mass point}

\item{\code{bins}}{[vector or integer] bins values}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
`self`
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_ratio_histogram-clone"></a>}}
\if{latex}{\out{\hypertarget{method-rv_ratio_histogram-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_ratio_histogram$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
