% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GetResults.R
\name{GetResults}
\alias{GetResults}
\title{Optimizely API to extract results of individual experiment}
\usage{
GetResults(experiment.id, result.type = "stats", audience.id = NA,
  dimension.id = NA, dimension.value = NA)
}
\arguments{
\item{experiment.id}{experiment identifier.}

\item{result.type}{Type of results to be extracted (valid options 'stats' or 'results')
Setting this argument to results  will extract top-level results.This option will be consistent with Optimizely Results page for experiments started before Jan 21, 2015. Default is set to 'stats'
Default is set to stats to extract results from  Optimizely Stats engine.}

\item{audience.id}{Audience identifier. Setting this parameter can be used to filter experiment results by particular audience.}

\item{dimension.id}{Dimension identifier. Setting this parameter together with dimension.value to filter results to visitors with custom dimension value. Default to NA}

\item{dimension.value}{value of a dimension. Use this in combination with dimension.id}
}
\value{
data frame with experiment results. A data frame representing every combination of variations and goals that have been defined for the experiment. For example, if there are three variations and two goals defined for an experiment, the response will contain six rows representing each variation_id and goal_id combination
}
\description{
\code{GetResults} extracts results for an individual experiment.
Metrics  for each experiment are listed for every combination of variations and goals defined for that experiment. All experiments started on or after January 21 2015 have statistics computed by Optimizely Stats Engine.
}
\examples{
\dontrun{
# Extract results of a single experiment
# Assign token before getting results
# set_token('abcdefghihjklmnopqrs:54321')
# Default results
exp.df<-GetResults('123456')

# Change result type to gather results
exp.df<-GetResults('123456',result.type='results)

# Filter results by audience
exp.df<-GetResults('123456',audience.id='123141')

# filter results by dimension

exp.df<-GetResults('123456',dimension.id='456', dimension.value='state')


}
}
\seealso{
\code{\link{GetExperimentResults}}
}

