% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSR_SE.R
\name{DSR.SE}
\alias{DSR.SE}
\title{Standard Error Estimate for Downside Sharpe Ratio (DSR) of Returns}
\usage{
DSR.SE(
  data,
  rf = 0,
  se.method = c("IFiid", "IFcor", "IFcorAdapt", "IFcorPW", "BOOTiid", "BOOTcor")[1, 4],
  cleanOutliers = FALSE,
  fitting.method = c("Exponential", "Gamma")[1],
  d.GLM.EN = 5,
  freq.include = c("All", "Decimate", "Truncate")[1],
  freq.par = 0.5,
  corOut = c("none", "retCor", "retIFCor", "retIFCorPW")[1],
  return.coef = FALSE,
  ...
)
}
\arguments{
\item{data}{Data of returns for one or multiple assets or portfolios.}

\item{rf}{Risk free rate.}

\item{se.method}{A character string indicating which method should be used to compute
the standard error of the estimated standard deviation. One or a combination of:
\code{"IFiid"} (default), \code{"IFcor"} (default), \code{"IFcorPW"}, \code{"IFcorAdapt"},
\code{"BOOTiid"} or \code{"BOOTcor"}.}

\item{cleanOutliers}{Boolean variable to indicate whether the pre-whitenning of the influence functions TS should be done through
a robust filter. Default if FALSE.}

\item{fitting.method}{Distribution used in the standard errors computation. Should be one of "Exponential" (default) or "Gamma".}

\item{d.GLM.EN}{Order of the polynomial for the Exponential or Gamma fitting. Default polynomial order of 5.}

\item{freq.include}{Frequency domain inclusion criteria. Must be one of "All" (default), "Decimate" or "Truncate."}

\item{freq.par}{Percentage of the frequency used if \code{"freq.include"} is "Decimate" or "Truncate." Default is 0.5.}

\item{corOut}{Return correlation of the returns or the influence function transformed returns.
Must be one of "retCor", "retIFCor" or "none" (default).}

\item{return.coef}{Boolean variable to indicate whether the coefficients of the penalized GLM fit are returned. Default if FALSE.}

\item{...}{Additional parameters.}
}
\value{
A vector or a list depending on \code{se.method}.
}
\description{
\code{ES.SE} computes the standard error of the downside Sharpe ratio of the returns.
}
\examples{
# Loading data
data(edhec, package = "PerformanceAnalytics")
# Changing the data colnames
names(edhec)  =  c("CA", "CTA", "DIS", "EM", "EMN",
                   "ED", "FIA", "GM", "LS", "MA",
                   "RV", "SS", "FOF")
# Computing the standard errors for
# the two influence functions based approaches
DSR.SE(edhec, se.method = c("IFiid","IFcor"),
       cleanOutliers = FALSE,
       fitting.method = c("Exponential", "Gamma")[1])

}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
