% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrestoConnection.R, R/dbCreateTable.R,
%   R/dbCreateTableAs.R, R/dbExistsTable.R, R/dbGetQuery.R, R/dbListFields.R,
%   R/dbListTables.R, R/dbReadTable.R, R/dbRemoveTable.R, R/dbSendQuery.R,
%   R/dbWriteTable.R, R/sqlCreateTable.R, R/sqlCreateTableAs.R
\docType{class}
\name{PrestoConnection-class}
\alias{PrestoConnection-class}
\alias{show,PrestoConnection-method}
\alias{.dbCreateTable}
\alias{dbCreateTable,PrestoConnection-method}
\alias{.dbCreateTableAs}
\alias{dbCreateTableAs,PrestoConnection-method}
\alias{dbExistsTable,PrestoConnection,character-method}
\alias{dbGetQuery,PrestoConnection,character-method}
\alias{dbListFields,PrestoConnection,character-method}
\alias{dbListTables,PrestoConnection-method}
\alias{.dbReadTable}
\alias{dbReadTable,PrestoConnection,character-method}
\alias{.dbRemoveTable}
\alias{dbRemoveTable,PrestoConnection,character-method}
\alias{dbSendQuery,PrestoConnection,character-method}
\alias{.dbWriteTable}
\alias{dbWriteTable,PrestoConnection,character,data.frame-method}
\alias{.sqlCreateTable}
\alias{sqlCreateTable,PrestoConnection-method}
\alias{.sqlCreateTableAs}
\alias{sqlCreateTableAs,PrestoConnection-method}
\title{S4 implementation of \code{DBIConnection} for Presto.}
\usage{
\S4method{show}{PrestoConnection}(object)

\S4method{dbCreateTable}{PrestoConnection}(
  conn,
  name,
  fields,
  with = NULL,
  ...,
  row.names = NULL,
  temporary = FALSE
)

\S4method{dbCreateTableAs}{PrestoConnection}(conn, name, sql, overwrite = FALSE, with = NULL, ...)

\S4method{dbExistsTable}{PrestoConnection,character}(conn, name, ...)

\S4method{dbGetQuery}{PrestoConnection,character}(conn, statement, ..., quiet = getOption("rpresto.quiet"))

\S4method{dbListFields}{PrestoConnection,character}(conn, name, ...)

\S4method{dbListTables}{PrestoConnection}(conn, pattern, ...)

\S4method{dbReadTable}{PrestoConnection,character}(conn, name, ...)

\S4method{dbRemoveTable}{PrestoConnection,character}(conn, name, ..., fail_if_missing = TRUE)

\S4method{dbSendQuery}{PrestoConnection,character}(conn, statement, ..., quiet = getOption("rpresto.quiet"))

\S4method{dbWriteTable}{PrestoConnection,character,data.frame}(
  conn,
  name,
  value,
  overwrite = FALSE,
  ...,
  append = FALSE,
  field.types = NULL,
  temporary = FALSE,
  row.names = FALSE,
  with = NULL
)

\S4method{sqlCreateTable}{PrestoConnection}(
  con,
  table,
  fields,
  row.names = NA,
  temporary = FALSE,
  with = NULL,
  ...
)

\S4method{sqlCreateTableAs}{PrestoConnection}(con, name, sql, with = NULL, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{name}{The table name, passed on to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[DBI:Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[DBI:SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{fields}{Either a character vector or a data frame.

A named character vector: Names are column names, values are types.
Names are escaped with \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}.
Field types are unescaped.

A data frame: field types are generated using
\code{\link[DBI:dbDataType]{dbDataType()}}.}

\item{with}{An optional WITH clause for the CREATE TABLE statement.}

\item{...}{Other parameters passed on to methods.}

\item{overwrite}{a logical specifying whether to overwrite an existing table
or not. Its default is \code{FALSE}.}

\item{quiet}{If a progress bar should be shown for long queries (which run
for more than 2 seconds. Default to \code{getOption("rpresto.quiet")} which
if not set, defaults to \code{NA} which turns on the progress bar for
interactive queries.}

\item{pattern}{optional SQL pattern for filtering table names, e.g. '\%test\%'}

\item{fail_if_missing}{If \code{FALSE}, \code{dbRemoveTable()} succeeds if the
table doesn't exist.}

\item{value}{a \link{data.frame} (or coercible to data.frame).}

\item{append, field.types, temporary, row.names}{Ignored. Included for
compatibility with
generic.}

\item{con}{A database connection.}

\item{table}{The table name, passed on to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[DBI:Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[DBI:SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}
}
\description{
S4 implementation of \code{DBIConnection} for Presto.
}
\keyword{internal}
