% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{set_env}
\alias{set_env}
\title{Retrieve the environment settings to run QGIS from within R}
\usage{
set_env(root = NULL, ltr = TRUE)
}
\arguments{
\item{root}{Root path to the QGIS-installation. If you do not specify 
function parameter \code{root}, the function looks for \code{qgis.bat} on 
your C: drive under Windows. If you are on a Mac, it looks for 
\code{QGIS.app} under "Applications" and "/usr/local/Cellar/". On Linux, 
\code{set_env} assumes that your root path is "/usr".}

\item{ltr}{If \code{TRUE}, \code{set_env} will use the long term release of
QGIS, if available (only for Windows).}
}
\value{
The function returns a list containing all the path necessary to run 
  QGIS from within R. This is the root path, the QGIS prefix path and the 
  path to the Python plugins.
}
\description{
\code{set_env} tries to find all the paths necessary to run QGIS
  from within R.
}
\examples{
\dontrun{
# Letting set_env look for the QGIS installation might take a while depending
# on how full your C: drive is (Windows)
set_env()
# It is much faster (0 sec) to explicitly state the root path to the QGIS 
# installation on your machine
set_env("C:/OSGEO4~1")  # Windows example
}

}
\author{
Jannes Muenchow, Patrick Schratz
}

