% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_funs.R
\name{get_extent}
\alias{get_extent}
\title{Retrieve the joint extent of all specified spatial objects}
\usage{
get_extent(params, type_name)
}
\arguments{
\item{params}{A parameter-argument list as returned by \code{\link[=get_args_man]{get_args_man()}} or
\code{\link[=pass_args]{pass_args()}}, which contains all spatial objects from which the joint
extent should be retrieved.}

\item{type_name}{A character string containing the QGIS parameter type for
each parameter (boolean, multipleinput, extent, number, etc.) of \code{params}.
The Python method \code{RQGIS.get_args_man} returns a Python dictionary with one
of its elements corresponding to the type_name (see also the example
section).}
}
\description{
Retrieve the joint extent of all specified spatial objects by
running through a parameter-argument list while merging the extents of all
spatial objects. This is mostly needed for the \code{GRASS_REGION_PARAMETER}.
Still there are geoalgorithms which require an extent object.
}
\examples{
\dontrun{
library("RQGIS")
library("raster")
library("reticulate")
r <- raster(ncol = 100, nrow = 100)
r1 <- crop(r, extent(-10, 11, -10, 11))
r2 <- crop(r, extent(0, 20, 0, 20))
r3 <- crop(r, extent(9, 30, 9, 30))
r1[] <- 1:ncell(r1)
r2[] <- 1:ncell(r2)
r3[] <- 1:ncell(r3)
alg <- "grass7:r.patch"
out <- py_run_string(sprintf("out = RQGIS.get_args_man('\%s')", alg))$out
params <- get_args_man(alg)
params$input <- list(r1, r2, r3)
get_extent(params = params, type_name = out$type_name)
# or if we save the input rasters in files stored on disk
params[] <- save_spatial_objects(params = params,
                                 type_name = out$type_name)
get_extent(params = params, type_name = out$type_name)
}
}
\author{
Jannes Muenchow
}
\keyword{internal}
