% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mahal_dist.R
\name{mahal_dist}
\alias{mahal_dist}
\title{Calculate the pairwise Mahalanobis distances between observations}
\usage{
mahal_dist(x, Cov, ...)
}
\arguments{
\item{x}{A numeric matrix of data frame.}

\item{Cov}{A covariance matrix with the same number of variables as the data.}

\item{...}{Other arguments passed to \code{\link[stats]{dist}}.}
}
\value{
An object of class "dist".
}
\description{
This function emulates the \code{\link[stats]{dist}} function
but allows a covariance matrix (Cov) to be included for standardizing
distances.  It is assumed that the Covariance matrix makes sense with
respect to the data, and that the number of variables match between data and covariance matrix.
}
\details{
No tests are performed on distances but could be performed with the 
\code{\link{pairwise}} function.  Distances are only calculated if
the covariance matrix is not singular.
}
\examples{

# Using the Pupfish data (see lm.rrpp help for more detail)

data(Pupfish)
Pupfish$Y <- ordinate(Pupfish$coords)$x[, 1:3]
fit <- lm.rrpp(Y ~ Sex * Pop, SS.type = "I", 
data = Pupfish, print.progress = FALSE, iter = 0)
means <- unique(model.matrix(fit)) \%*\% coef(fit)
rownames(means) <- unique(interaction(Pupfish$Sex, Pupfish$Pop))
means
S <- getResCov(fit)
dist(means)
mahal_dist(means, S)
}
\author{
Michael Collyer
}
\keyword{analysis}
