% Generated by roxygen2 (4.0.2): do not edit by hand
\name{SinghJoarder}
\alias{SinghJoarder}
\title{Singh-Joarder model}
\usage{
SinghJoarder(z,p,pi,type=c("total","mean"),cl,N=NULL,pij=NULL)
}
\arguments{
\item{z}{vector of the observed variable; its length is equal to \eqn{n} (the sample size)}

\item{p}{proportion of marked cards with the sensitive question}

\item{pi}{vector of the first-order inclusion probabilities}

\item{type}{the estimator type: total or mean}

\item{cl}{confidence level}

\item{N}{size of the population. By default it is NULL}

\item{pij}{matrix of the second-order inclusion probabilities. By default it is NULL}
}
\value{
Point and confidence estimates of the sensitive characteristics using the Singh-Joarder model. The transformed variable is also reported, if required.
}
\description{
Computes the randomized response estimation, its variance estimation and its confidence interval through the Singh-Joarder model.
The function can also return the transformed variable.
The Singh-Joarder model was proposed by Singh and Joarder in 1997.
}
\details{
The basics of the Singh-Joarder scheme are similar to Warner's randomized response device, with the following difference. If a person labelled \eqn{i} bears
\eqn{A^c} he/she is told to say so if so guided by a card drawn from a box of \eqn{A} and \eqn{A^c} marked cards in proportions \eqn{p} and \eqn{(1-p),(0<p<1)}.
However, if he/she bears \eqn{A} and is directed by the card to admit it, he/she is told to postpone the reporting based on the first draw of the card from
the box but to report on the basis of a second draw. Therefore,
\deqn{z_i=\left \{\begin{array}{lcc}
1 & \textrm{if person } i \textrm{ responds "Yes"}\\
0 & \textrm{if person } i \textrm{ responds "No"}
\end{array}
\right .}
The transformed variable is \eqn{r_i=\frac{z_i-(1-p)}{(2p-1)+p(1-p)}} and the estimated variance is \eqn{\widehat{V}_R(r_i)=r_i(r_i-1)}.
}
\examples{
N=802
data(SinghJoarderData)
dat=with(SinghJoarderData,data.frame(z,Pi))
p=0.6
cl=0.95
SinghJoarder(dat$z,p,dat$Pi,"mean",cl,N)
}
\references{
Singh, S., Joarder, A.H. (1997).
\emph{Unknown repeated trials in randomized response sampling.}
Journal of the Indian Statistical Association, 30, 109-122.
}
\seealso{
\code{\link{SinghJoarderData}}

\code{\link{ResamplingVariance}}
}
\keyword{Confidence_interval}
\keyword{Estimation}
\keyword{Qualitative}
\keyword{Randomized_response}
\keyword{SinghJoarder}
\keyword{Transformed_variable}
\keyword{Variance}

