/*
 * Decompiled with CFR 0.152.
 */
package org.act.mip;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.ArrayUtils;

public class SolverOutput {
    private final List<String> selectedItemIdentifiers;
    private final List<Integer> selectedItemRowIndices;
    private final List<String> selectedPassageIdentifiers;
    private final List<Integer> selectedPassageRowIndices;
    private final List<Integer> passageRowIndexSequence;
    private final Double objective;
    private final SOLVER_STATS solverStatus;

    private SolverOutput(SolverOutputBuilder solverOutputBuilder) {
        this.selectedItemIdentifiers = Collections.unmodifiableList(solverOutputBuilder.selectedItemIdentifiers);
        this.selectedItemRowIndices = Collections.unmodifiableList(solverOutputBuilder.selectedItemRowIndices);
        this.selectedPassageIdentifiers = Collections.unmodifiableList(solverOutputBuilder.selectedPassageIdentifiers);
        this.selectedPassageRowIndices = Collections.unmodifiableList(solverOutputBuilder.selectedPassageRowIndices);
        this.passageRowIndexSequence = solverOutputBuilder.passageRowIndexSequence != null ? Collections.unmodifiableList(solverOutputBuilder.passageRowIndexSequence) : null;
        this.objective = solverOutputBuilder.objective;
        this.solverStatus = solverOutputBuilder.solverStatus;
    }

    public List<String> getSelectedItemIdentifiers() {
        return this.selectedItemIdentifiers;
    }

    public List<Integer> getSelectedItemRowIndices() {
        return this.selectedItemRowIndices;
    }

    public List<String> getSelectedPassageIdentifiers() {
        return this.selectedPassageIdentifiers;
    }

    public List<Integer> getSelectedPassageRowIndices() {
        return this.selectedPassageRowIndices;
    }

    public List<Integer> getPassageRowIndexSequence() {
        return this.passageRowIndexSequence;
    }

    public String[] getSelectedItemIdentifiersArray() {
        return this.selectedItemIdentifiers.toArray(new String[this.selectedItemIdentifiers.size()]);
    }

    public int[] getSelectedItemRowIndicesArray() {
        return ArrayUtils.toPrimitive((Integer[])this.selectedItemRowIndices.toArray(new Integer[this.selectedItemIdentifiers.size()]));
    }

    public String[] getSelectedPassageIdentifiersArray() {
        return this.selectedPassageIdentifiers.toArray(new String[this.selectedPassageIdentifiers.size()]);
    }

    public int[] getSelectedPassageRowIndicesArray() {
        return ArrayUtils.toPrimitive((Integer[])this.selectedPassageRowIndices.toArray(new Integer[this.selectedPassageRowIndices.size()]));
    }

    public Double getObjective() {
        return this.objective;
    }

    public SOLVER_STATS getSolverStatus() {
        return this.solverStatus;
    }

    public static class SolverOutputBuilder {
        private List<String> selectedItemIdentifiers = new ArrayList<String>();
        private List<Integer> selectedItemRowIndices = new ArrayList<Integer>();
        private List<String> selectedPassageIdentifiers = new ArrayList<String>();
        private List<Integer> selectedPassageRowIndices = new ArrayList<Integer>();
        private List<Integer> passageRowIndexSequence = new ArrayList<Integer>();
        private Double objective = new Double(0.0);
        private SOLVER_STATS solverStatus = SOLVER_STATS.OTHER;

        public SolverOutputBuilder selectedItemIdentifiers(List<String> newSelectedItemIdentifiers) {
            this.selectedItemIdentifiers = newSelectedItemIdentifiers;
            return this;
        }

        public SolverOutputBuilder selectedItemRowIndices(List<Integer> newSelectedItemRowIndices) {
            this.selectedItemRowIndices = newSelectedItemRowIndices;
            return this;
        }

        public SolverOutputBuilder selectedPassageIdentifiers(List<String> newSelectedPassageIdentifiers) {
            this.selectedPassageIdentifiers = newSelectedPassageIdentifiers;
            return this;
        }

        public SolverOutputBuilder selectedPassageRowIndices(List<Integer> newSelectedPassageRowIndices) {
            this.selectedPassageRowIndices = newSelectedPassageRowIndices;
            return this;
        }

        public SolverOutputBuilder passageRowIndexSequence(List<Integer> newPassageRowIndexSequence) {
            this.passageRowIndexSequence = newPassageRowIndexSequence;
            return this;
        }

        public SolverOutputBuilder objective(double newObjective) {
            this.objective = newObjective;
            return this;
        }

        public SolverOutputBuilder solverStatus(int code) {
            this.solverStatus = SOLVER_STATS.get(code);
            return this;
        }

        public SolverOutput build() {
            return new SolverOutput(this);
        }
    }

    public static enum SOLVER_STATS {
        OPTIMAL(2),
        UNFINISHED(4),
        INFEASIBLE(6),
        UNBOUNDED(8),
        OTHER(10);

        private static Map<Integer, SOLVER_STATS> lookup;
        private int code;

        private SOLVER_STATS(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static SOLVER_STATS get(int code) throws NoSuchElementException {
            if (!lookup.containsKey(code)) {
                throw new NoSuchElementException("The solver code " + code + " doesn't exist!");
            }
            return lookup.get(code);
        }

        static {
            lookup = new HashMap<Integer, SOLVER_STATS>();
            for (SOLVER_STATS s : SOLVER_STATS.values()) {
                lookup.put(s.getCode(), s);
            }
        }
    }
}

