/*
 * Decompiled with CFR 0.152.
 */
package org.act.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.act.cat.CatConfig;
import org.act.cat.CatConfigStandard;
import org.act.cat.ExposureControlConfig;
import org.act.cat.ExposureControlType;
import org.act.cat.ScoringMethodConfig;
import org.act.cat.ThetaRange;
import org.act.mip.SolverConfig;
import org.act.sim.AbstractCatSimulation;
import org.act.sim.CatSimulationStandard;
import org.act.sim.SimOutput;
import org.act.sol.InfeasibleTestConfigException;
import org.act.testdef.TestConfig;
import org.act.util.ContentTable;
import org.act.util.CsvUtils;
import org.act.util.ProbDistributionFactory;

public class RHelper {
    private RHelper() {
    }

    public static List<SimOutput> runSim(ScoringMethodConfig scoringMethodConfig, double initTheta, double scalingConstant, String exposureControlType, double rMax, int lValue, double absGap, double relGap, double intTol, boolean saveInput, String testConfigID, int testLength, String itempoolPath, String passagepoolPath, String constraintPath, boolean[] itemNumericColumn, boolean[] passageNumericColumn, boolean enableEnemyItem, int numPassageLB, int numPassageUB, int numItemPerPassageLB, int numItemPerPassageUB, String simID, int numExaminees, String trueThetaDistType, double[] trueThetaDistParams) throws IOException, InfeasibleTestConfigException {
        ExposureControlType ecType;
        SolverConfig solverConfig = new SolverConfig(absGap, relGap, intTol, saveInput);
        if (exposureControlType.equals("Item")) {
            ecType = ExposureControlType.ITEM;
        } else if (exposureControlType.equals("None")) {
            ecType = ExposureControlType.NONE;
        } else {
            throw new IllegalArgumentException("Invalid exposure control type!");
        }
        List<ThetaRange> thetaRanges = Arrays.asList(new ThetaRange(-8.0, 8.0));
        ExposureControlConfig exposureConfig = new ExposureControlConfig(ecType, thetaRanges, rMax);
        CatConfigStandard catConfig = new CatConfigStandard(solverConfig, initTheta, scalingConstant, scoringMethodConfig, exposureConfig, lValue);
        ContentTable.RowOriented itemPoolTable = CsvUtils.read(new FileInputStream(new File(itempoolPath)));
        TestConfig.Builder testConfigBuilder = new TestConfig.Builder(testLength, itemNumericColumn, itemPoolTable);
        testConfigBuilder.testConfigId(testConfigID).enableEnemyItemConstraint(enableEnemyItem);
        if (constraintPath.length() > 0) {
            ContentTable.RowOriented constraintTable = CsvUtils.read(new FileInputStream(new File(constraintPath)));
            testConfigBuilder.constraintTable(constraintTable);
        }
        if (passagepoolPath.length() > 0) {
            ContentTable.RowOriented passagepoolTable = CsvUtils.read(new FileInputStream(new File(passagepoolPath)));
            testConfigBuilder.passageTable(passagepoolTable).passageNumericColumn(passageNumericColumn).numPassageLB(numPassageLB).numPassageUB(numPassageUB).numItemPerPassageLB(numItemPerPassageLB).numItemPerPassageUB(numItemPerPassageUB);
        }
        TestConfig testConfig = testConfigBuilder.build();
        CatSimulationStandard catSim = new CatSimulationStandard(simID, numExaminees, ProbDistributionFactory.getProbDistribution(trueThetaDistType, trueThetaDistParams), testConfig, (CatConfig)catConfig, (Boolean)true);
        List<SimOutput> simOutputs = ((AbstractCatSimulation)catSim).runSim();
        return simOutputs;
    }
}

