/*
 * Decompiled with CFR 0.152.
 */
package org.act.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public final class PrimitiveArrays {
    private PrimitiveArrays() {
    }

    public static int[] intArray(List<String> strings) {
        return strings.stream().mapToInt(Integer::valueOf).toArray();
    }

    public static double[] doubleArray(List<String> strings) {
        return strings.stream().mapToDouble(Double::valueOf).toArray();
    }

    public static boolean[] booleanArray(List<String> strings) {
        boolean[] values = new boolean[strings.size()];
        Iterator<String> stringIterator = strings.iterator();
        for (int i = 0; i < values.length; ++i) {
            values[i] = Boolean.valueOf(stringIterator.next());
        }
        return values;
    }

    public static List<String> stringList(int[] array) {
        return Arrays.stream(array).mapToObj(String::valueOf).collect(Collectors.toList());
    }

    public static List<String> stringList(double[] array) {
        return Arrays.stream(array).mapToObj(String::valueOf).collect(Collectors.toList());
    }

    public static List<String> stringList(boolean[] array) {
        ArrayList<String> strings = new ArrayList<String>(array.length);
        for (boolean value : array) {
            strings.add(String.valueOf(value));
        }
        return strings;
    }

    public static int[] select(int[] array, int ... values) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < array.length; ++j) {
                if (values[i] != array[j]) continue;
                results.add(j);
            }
        }
        return PrimitiveArrays.getIntArray(results);
    }

    public static int[] select(double[] array, double ... values) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < array.length; ++j) {
                if (values[i] != array[j]) continue;
                results.add(j);
            }
        }
        return PrimitiveArrays.getIntArray(results);
    }

    public static int[] select(boolean[] array, boolean ... values) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < array.length; ++j) {
                if (values[i] != array[j]) continue;
                results.add(j);
            }
        }
        return PrimitiveArrays.getIntArray(results);
    }

    public static int[] select(String[] array, String ... values) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < array.length; ++j) {
                if (!values[i].equals(array[j])) continue;
                results.add(j);
            }
        }
        return PrimitiveArrays.getIntArray(results);
    }

    public static int count(boolean[] array, boolean value) {
        int count = 0;
        for (boolean aValue : array) {
            if (value != aValue) continue;
            ++count;
        }
        return count;
    }

    public static int count(List<Boolean> aList, boolean value) {
        int count = 0;
        for (boolean aValue : aList) {
            if (value != aValue) continue;
            ++count;
        }
        return count;
    }

    public static int count(String[] array, String ... values) {
        int count = 0;
        block0: for (String aValue : array) {
            for (String matchValue : values) {
                if (!aValue.equals(matchValue)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    public static int count(List<String> aList, String ... values) {
        return PrimitiveArrays.count(aList.toArray(new String[0]), values);
    }

    public static String[] subSamples(String[] array, int ... indices) {
        String[] subSamples = new String[indices.length];
        int count = 0;
        for (int index : indices) {
            subSamples[count] = array[index];
            ++count;
        }
        return subSamples;
    }

    public static List<String> subSamples(List<String> aList, int ... indices) {
        ArrayList<String> subList = new ArrayList<String>(indices.length);
        for (int index : indices) {
            subList.add(aList.get(index));
        }
        return subList;
    }

    private static int[] getIntArray(List<Integer> list) {
        int[] intArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            intArray[i] = list.get(i);
        }
        return intArray;
    }
}

