filedatetime<-function (orgtim, tims) 
{
 ###   orgtime is a vector c(yr, jd, hr, mi, sec)
  
  rd = list(yr=orgtim[1],  jd=orgtim[2], hr=orgtim[3], mi=orgtim[4], sec=orgtim[5]+tims)

  rd = recdate(jd = rd$jd, hr = rd$hr, mi = rd$mi, sec = rd$sec, 
    yr = rd$yr)
  MODAY = getmoday(rd$jd, rd$yr)
  gdates = paste(sep = "-", formatC(rd$yr, wid = 3, flag = "0"), 
    formatC(MODAY$mo, wid = 2, flag = "0"), formatC(MODAY$dom, 
                                 wid = 2, flag = "0"))
  mysec = floor(rd$sec)
  mymcrsec = floor((rd$sec - mysec) * 1e+06)
  hours = rd$hr
  gtimes = paste(sep = ":", formatC(hours, wid = 2, flag = "0"), 
    formatC(rd$mi, wid = 2, flag = "0"), formatC(mysec, wid = 2, 
                              flag = "0"))
  amcrsec = formatC(as.integer(mymcrsec), wid = 6, flag = "0")
  charvec = paste(sep="_", gdates, gtimes, amcrsec)
  cat(charvec, sep = "\n")

  return( charvec[which.min(tims)] )
}




