% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils.R
\name{get_server_details}
\alias{get_server_details}
\title{Get server details from YAML file}
\usage{
get_server_details(server, file = NULL)
}
\arguments{
\item{server}{corresponds to the server name key in the YAML \code{file} and
should be a string.}

\item{file}{defaults to \code{NULL} which means that it will use
\code{$HOME/sql.yaml}.}
}
\value{
a named list of \code{server} details if this is specified in the
\code{file}. It stops and returns an error if \code{port} and \code{type}
keys are not specified for found \code{server}. \code{NULL} is returned if
the \code{file} does not contain the \code{server} key
}
\description{
The \code{sql.yaml} file in a user's \code{HOME} directory can store
server details and login credentials (in plain text). This works around
the instability associated with jTDS's single-sign on functionality.
The YAML file format is documented in this package's \code{README} file, while
an example is provided in \code{extdata/sql.yaml} (see example). At a
high level, each server should be documented in its own associative array
with each aspect of the server documented in an associative array.
}
\examples{
# See link below
\dontrun{
aw <- dbConnect(RSQLServer::SQLServer(), server = "mhknbn2kdz.database.windows.net",
 database = 'AdventureWorks2012',
 properties = list(user = "sqlfamily", password = "sqlf@m1ly"))
dbListTables(aw)
}
}
\seealso{
\href{https://github.com/imanuelcostigan/RSQLServer/blob/master/README.md}{RSQLServer README}
\href{https://github.com/yaml/yaml}{YAML}
\href{http://sqlblog.com/blogs/jamie_thomson/archive/2012/03/27/adventureworks2012-now-available-to-all-on-sql-azure.aspx}{Example SQL Server instance}
}
\keyword{internal}
