/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 56 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 248
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 60
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  int yy46;
  struct LikeOp yy72;
  Expr* yy172;
  ExprList* yy174;
  Select* yy219;
  struct LimitVal yy234;
  TriggerStep* yy243;
  struct TrigEvent yy370;
  SrcList* yy373;
  Expr * yy386;
  struct {int value; int mask;} yy405;
  Token yy410;
  IdList* yy432;
  int yy495;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 586
#define YYNRULE 310
#define YYERRORSYMBOL 139
#define YYERRSYMDT yy495
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   290,   67,  294,   69,  150,  168,  206,  435,   61,   61,
 /*    10 */    61,   61,   66,   63,   63,   63,   63,   64,   64,   65,
 /*    20 */    65,   65,   66,  445,  325,  164,  448,  454,   68,   63,
 /*    30 */    63,   63,   63,   64,   64,   65,   65,   65,   66,   64,
 /*    40 */    64,   65,   65,   65,   66,   60,   58,  298,  458,  459,
 /*    50 */   455,  455,   62,   62,   61,   61,   61,   61,  517,   63,
 /*    60 */    63,   63,   63,   64,   64,   65,   65,   65,   66,  290,
 /*    70 */   321,   67,  435,   69,  150,   79,  160,  114,  224,  317,
 /*    80 */   229,  318,  172,  249,  897,  120,  585,  519,  522,    2,
 /*    90 */   250,  571,  426,   35,  223,  448,  454,  532,   20,   57,
 /*   100 */   388,  385,   63,   63,   63,   63,   64,   64,   65,   65,
 /*   110 */    65,   66,  290,  477,   60,   58,  298,  458,  459,  455,
 /*   120 */   455,   62,   62,   61,   61,   61,   61,  393,   63,   63,
 /*   130 */    63,   63,   64,   64,   65,   65,   65,   66,  448,  454,
 /*   140 */    91,  314,  389,  484,  236,  387,  271,  204,    2,   83,
 /*   150 */   586,  388,  385,  474,  196,  443,  209,   60,   58,  298,
 /*   160 */   458,  459,  455,  455,   62,   62,   61,   61,   61,   61,
 /*   170 */   170,   63,   63,   63,   63,   64,   64,   65,   65,   65,
 /*   180 */    66,  290,  490,  443,  209,  274,  109,  272,  427,  447,
 /*   190 */   406,  284,  394,  395,  445,  521,  164,  321,  511,   67,
 /*   200 */   530,   69,  150,  567,  427,  143,  520,  448,  454,  145,
 /*   210 */   146,  583,  888,  376,  888,  515,  171,  156,  518,  426,
 /*   220 */    40,  340,  430,   19,  290,  140,   60,   58,  298,  458,
 /*   230 */   459,  455,  455,   62,   62,   61,   61,   61,   61,  384,
 /*   240 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   250 */   448,  454,  580,  408,  409,  432,  432,  432,  332,  335,
 /*   260 */   240,  549,   67,  472,   69,  150,  273,  290,  294,   60,
 /*   270 */    58,  298,  458,  459,  455,  455,   62,   62,   61,   61,
 /*   280 */    61,   61,  124,   63,   63,   63,   63,   64,   64,   65,
 /*   290 */    65,   65,   66,  448,  454,  405,  514,  393,  293,  548,
 /*   300 */    65,   65,   65,   66,  511,  393,  546,  409,  447,  297,
 /*   310 */   438,  439,   60,   58,  298,  458,  459,  455,  455,   62,
 /*   320 */    62,   61,   61,   61,   61,  206,   63,   63,   63,   63,
 /*   330 */    64,   64,   65,   65,   65,   66,  523,  518,  369,  290,
 /*   340 */    75,  430,  148,  494,  224,  317,  229,  318,  172,  249,
 /*   350 */   370,  267,  266,    1,  579,  289,  250,  393,  420,  449,
 /*   360 */   450,  206,  394,  395,  177,  448,  454,  343,  346,  347,
 /*   370 */   394,  395,  208,  360,  432,  432,  432,  363,  168,  348,
 /*   380 */   435,  452,  453,   78,   60,   58,  298,  458,  459,  455,
 /*   390 */   455,   62,   62,   61,   61,   61,   61,  480,   63,   63,
 /*   400 */    63,   63,   64,   64,   65,   65,   65,   66,  290,  451,
 /*   410 */   177,  566,  497,  343,  346,  347,   21,  321,  522,  321,
 /*   420 */   435,  321,  394,  395,  321,  348,  479,  404,   20,  568,
 /*   430 */   569,  493,  151,  177,  448,  454,  343,  346,  347,  426,
 /*   440 */    34,  426,   34,  426,   34,  435,  426,   34,  348,  197,
 /*   450 */   237,  147,  531,   60,   58,  298,  458,  459,  455,  455,
 /*   460 */    62,   62,   61,   61,   61,   61,  427,   63,   63,   63,
 /*   470 */    63,   64,   64,   65,   65,   65,   66,  290,  230,  351,
 /*   480 */   412,  516,  301,  427,  337,  435,  321,  155,  321,  299,
 /*   490 */   321,  208,  413,  154,  469,    9,  469,  462,  468,  393,
 /*   500 */    74,  469,   76,  448,  454,  414,  173,  410,  426,   40,
 /*   510 */   426,   48,  426,   48,  324,  438,  439,  411,  327,  479,
 /*   520 */   461,  461,   60,   58,  298,  458,  459,  455,  455,   62,
 /*   530 */    62,   61,   61,   61,   61,  463,   63,   63,   63,   63,
 /*   540 */    64,   64,   65,   65,   65,   66,  290,  321,  503,  238,
 /*   550 */   253,  484,  393,  341,  412,  149,  425,  309,  338,  310,
 /*   560 */   424,  393,  292,  393,  394,  395,  413,  250,  504,  426,
 /*   570 */    27,  241,  448,  454,  435,  426,    3,  208,  543,  414,
 /*   580 */   322,  331,  583,  887,  327,  887,  461,  461,  488,  427,
 /*   590 */   242,   60,   58,  298,  458,  459,  455,  455,   62,   62,
 /*   600 */    61,   61,   61,   61,  255,   63,   63,   63,   63,   64,
 /*   610 */    64,   65,   65,   65,   66,  290,  371,  394,  395,  492,
 /*   620 */    90,  302,  327,  580,  461,  461,  394,  395,  394,  395,
 /*   630 */   321,  529,  498,  321,  396,  397,  398,  522,  528,  435,
 /*   640 */   219,  448,  454,  259,  481,  257,  576,   20,  327,  300,
 /*   650 */   461,  461,  426,   28,  545,  426,   23,  509,  290,  342,
 /*   660 */    60,   58,  298,  458,  459,  455,  455,   62,   62,   61,
 /*   670 */    61,   61,   61,  321,   63,   63,   63,   63,   64,   64,
 /*   680 */    65,   65,   65,   66,  448,  454,  425,  539,  357,  539,
 /*   690 */   424,  261,  303,  509,  822,  426,   32,  436,  509,   22,
 /*   700 */   188,  290,  509,   60,   58,  298,  458,  459,  455,  455,
 /*   710 */    62,   62,   61,   61,   61,   61,  321,   63,   63,   63,
 /*   720 */    63,   64,   64,   65,   65,   65,   66,  448,  454,  174,
 /*   730 */   175,  176,  381,  216,  427,  484,  248,  304,  426,   53,
 /*   740 */   509,  509,  261,  261,  290,  261,   60,   70,  298,  458,
 /*   750 */   459,  455,  455,   62,   62,   61,   61,   61,   61,  368,
 /*   760 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   770 */   448,  454,  247,  392,  244,  305,  307,  248,  167,  156,
 /*   780 */   364,  248,  383,  262,  556,  261,  558,  290,  261,  115,
 /*   790 */    58,  298,  458,  459,  455,  455,   62,   62,   61,   61,
 /*   800 */    61,   61,  321,   63,   63,   63,   63,   64,   64,   65,
 /*   810 */    65,   65,   66,  448,  454,  488,  467,  488,   12,  248,
 /*   820 */   248,  207,    5,  367,  426,   24,  559,  367,   54,  560,
 /*   830 */   312,  119,  441,  441,  298,  458,  459,  455,  455,   62,
 /*   840 */    62,   61,   61,   61,   61,  321,   63,   63,   63,   63,
 /*   850 */    64,   64,   65,   65,   65,   66,   71,  328,  321,    4,
 /*   860 */   321,  541,  321,  296,  261,  540,  261,  426,   51,  321,
 /*   870 */   161,  323,   71,  328,  321,    4,  358,  359,  308,  296,
 /*   880 */   426,   96,  426,   93,  426,   98,  225,  323,  330,  217,
 /*   890 */   431,  426,   99,  218,  444,  321,  426,  110,  226,  447,
 /*   900 */   321,  261,  321,  421,  330,  275,  190,  375,  321,  333,
 /*   910 */   422,  321,  417,  418,  470,  447,  321,  426,  111,   73,
 /*   920 */    72,  192,  426,   16,  426,   97,  152,   71,  319,  320,
 /*   930 */   426,   33,  430,  426,   94,   73,   72,  491,  426,   52,
 /*   940 */   321,  478,  277,   71,  319,  320,   71,  328,  430,    4,
 /*   950 */   321,  206,  321,  296,  321,  427,  486,  321,  169,  179,
 /*   960 */   427,  323,  426,  112,  620,  432,  432,  432,  433,  434,
 /*   970 */    11,  378,  426,  113,  426,   25,  426,   36,  330,  426,
 /*   980 */    37,  432,  432,  432,  433,  434,   11,  483,  326,  447,
 /*   990 */   158,  206,  321,  427,  173,  220,  221,  222,  101,  182,
 /*  1000 */   495,  321,   12,  321,  377,  321,   81,  321,  487,   73,
 /*  1010 */    72,  202,  581,  279,  426,   26,  246,   71,  319,  320,
 /*  1020 */   280,  321,  430,  426,   38,  426,   39,  426,   41,  426,
 /*  1030 */    42,  321,  199,  427,  548,  502,  501,  537,  538,  198,
 /*  1040 */   321,  499,  201,  426,   43,  321,  500,  507,  321,  124,
 /*  1050 */   292,  321,  582,  426,   29,  432,  432,  432,  433,  434,
 /*  1060 */    11,  505,  426,   30,  456,  506,  321,  426,   44,  200,
 /*  1070 */   426,   45,  321,  426,   46,  252,  321,  124,  350,  321,
 /*  1080 */   124,  321,  524,  254,  185,  374,  276,  266,  426,   47,
 /*  1090 */   578,  291,  288,  256,  426,   31,  206,  258,  426,   10,
 /*  1100 */   260,  426,   49,  426,   50,  355,  544,  552,  124,  169,
 /*  1110 */   553,  265,   88,  362,  365,  563,  366,   88,  268,   18,
 /*  1120 */   380,  269,  270,  555,  565,  278,  379,  281,  227,  282,
 /*  1130 */   575,  142,  231,  402,  329,  440,  442,  473,  498,  159,
 /*  1140 */   476,  551,  508,  562,  510,  391,  399,  400,  401,    8,
 /*  1150 */   315,  316,  295,   81,  420,  336,  232,   80,  345,  407,
 /*  1160 */   415,  334,  228,   56,   77,  419,  423,  166,  471,  416,
 /*  1170 */   210,  239,  474,  475,  211,  121,   82,  339,  102,  512,
 /*  1180 */   352,  180,  285,  428,  356,  533,  525,  181,  526,  527,
 /*  1190 */   263,  354,  233,  513,  234,  286,  184,  183,   85,  535,
 /*  1200 */   235,  186,  429,  117,  361,  128,  547,  373,  189,  572,
 /*  1210 */   243,  577,  485,  245,  129,  489,  212,  372,  130,  311,
 /*  1220 */   554,  573,  214,  215,  574,   95,  134,  131,  132,  561,
 /*  1230 */   390,  403,  116,  213,  205,  100,   55,  621,  622,  162,
 /*  1240 */   138,  163,   59,  457,  137,  437,  446,  460,  464,  139,
 /*  1250 */   153,  482,  465,    6,  536,  165,  466,   13,    7,  122,
 /*  1260 */    12,  123,  496,  157,  344,  103,  349,  251,  104,   84,
 /*  1270 */   105,  178,  226,  353,  141,  534,  125,  169,  264,  306,
 /*  1280 */   187,  106,  287,  550,   89,   92,  127,   86,   87,  126,
 /*  1290 */   542,   17,  191,  108,   14,  194,  193,  557,  135,  133,
 /*  1300 */   195,  136,   15,  564,  570,  118,  107,  203,  144,  313,
 /*  1310 */   382,  283,  386,  559,  584,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  218,   16,  220,  221,   21,  111,   23,   70,   71,
 /*    10 */    72,   73,   84,   75,   76,   77,   78,   79,   80,   81,
 /*    20 */    82,   83,   84,  162,  163,  164,   42,   43,   74,   75,
 /*    30 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   79,
 /*    40 */    80,   81,   82,   83,   84,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,   73,  170,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */   148,  218,   88,  220,  221,   22,   90,   91,   92,   93,
 /*    80 */    94,   95,   96,   97,  140,  141,  142,  170,  148,  145,
 /*    90 */   104,  238,  170,  171,  154,   42,   43,  157,  158,   46,
 /*   100 */     1,    2,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   110 */    83,   84,   16,   22,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,   73,   23,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   140 */    44,  143,  144,  162,  222,  142,   14,  149,  145,   19,
 /*   150 */     0,    1,    2,   23,  156,   79,   80,   61,   62,   63,
 /*   160 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   170 */   156,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   180 */    84,   16,  201,   79,   80,   53,   21,   55,  190,   59,
 /*   190 */   169,  159,   88,   89,  162,  163,  164,  148,  177,  218,
 /*   200 */   182,  220,  221,   99,  190,  114,  161,   42,   43,   79,
 /*   210 */    80,   19,   20,  215,   22,  170,  202,  203,   88,  170,
 /*   220 */   171,  207,   92,   19,   16,   21,   61,   62,   63,   64,
 /*   230 */    65,   66,   67,   68,   69,   70,   71,   72,   73,  241,
 /*   240 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   250 */    42,   43,   60,  186,  187,  125,  126,  127,  187,  210,
 /*   260 */   211,   11,  218,  219,  220,  221,  134,   16,   16,   61,
 /*   270 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   280 */    72,   73,   22,   75,   76,   77,   78,   79,   80,   81,
 /*   290 */    82,   83,   84,   42,   43,  168,  169,   23,  151,   49,
 /*   300 */    81,   82,   83,   84,  177,   23,  186,  187,   59,  165,
 /*   310 */   166,  167,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   320 */    69,   70,   71,   72,   73,  111,   75,   76,   77,   78,
 /*   330 */    79,   80,   81,   82,   83,   84,  182,   88,  124,   16,
 /*   340 */   132,   92,   22,   20,   92,   93,   94,   95,   96,   97,
 /*   350 */   100,  101,  102,   19,  244,  245,  104,   23,   98,   42,
 /*   360 */    43,  111,   88,   89,   90,   42,   43,   93,   94,   95,
 /*   370 */    88,   89,  228,  226,  125,  126,  127,  230,   21,  105,
 /*   380 */    23,   64,   65,  132,   61,   62,   63,   64,   65,   66,
 /*   390 */    67,   68,   69,   70,   71,   72,   73,  115,   75,   76,
 /*   400 */    77,   78,   79,   80,   81,   82,   83,   84,   16,   92,
 /*   410 */    90,  148,   20,   93,   94,   95,   19,  148,  148,  148,
 /*   420 */    23,  148,   88,   89,  148,  105,   22,  157,  158,  166,
 /*   430 */   167,   20,  156,   90,   42,   43,   93,   94,   95,  170,
 /*   440 */   171,  170,  171,  170,  171,   88,  170,  171,  105,  156,
 /*   450 */   148,  181,  182,   61,   62,   63,   64,   65,   66,   67,
 /*   460 */    68,   69,   70,   71,   72,   73,  190,   75,   76,   77,
 /*   470 */    78,   79,   80,   81,   82,   83,   84,   16,  191,   16,
 /*   480 */    12,   20,  213,  190,  213,   88,  148,  148,  148,  213,
 /*   490 */   148,  228,   24,   89,  225,   19,  225,   20,  225,   23,
 /*   500 */   131,  225,  133,   42,   43,   37,   43,   39,  170,  171,
 /*   510 */   170,  171,  170,  171,  165,  166,  167,   49,  107,  115,
 /*   520 */   109,  110,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   530 */    69,   70,   71,   72,   73,   20,   75,   76,   77,   78,
 /*   540 */    79,   80,   81,   82,   83,   84,   16,  148,   30,  211,
 /*   550 */    20,  162,   23,  148,   12,  156,  108,  217,  148,  217,
 /*   560 */   112,   23,   99,   23,   88,   89,   24,  104,   50,  170,
 /*   570 */   171,  148,   42,   43,   23,  170,  171,  228,   18,   37,
 /*   580 */   148,   39,   19,   20,  107,   22,  109,  110,  148,  190,
 /*   590 */   201,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   600 */    70,   71,   72,   73,   14,   75,   76,   77,   78,   79,
 /*   610 */    80,   81,   82,   83,   84,   16,   56,   88,   89,   81,
 /*   620 */    21,  103,  107,   60,  109,  110,   88,   89,   88,   89,
 /*   630 */   148,  177,  178,  148,    7,    8,    9,  148,  184,   88,
 /*   640 */   146,   42,   43,   53,  115,   55,  157,  158,  107,  209,
 /*   650 */   109,  110,  170,  171,   94,  170,  171,  148,   16,   81,
 /*   660 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   670 */    71,   72,   73,  148,   75,   76,   77,   78,   79,   80,
 /*   680 */    81,   82,   83,   84,   42,   43,  108,  100,  101,  102,
 /*   690 */   112,  148,  183,  148,  134,  170,  171,   20,  148,   22,
 /*   700 */   156,   16,  148,   61,   62,   63,   64,   65,   66,   67,
 /*   710 */    68,   69,   70,   71,   72,   73,  148,   75,   76,   77,
 /*   720 */    78,   79,   80,   81,   82,   83,   84,   42,   43,  100,
 /*   730 */   101,  102,  189,  183,  190,  162,  227,  183,  170,  171,
 /*   740 */   148,  148,  148,  148,   16,  148,   61,   62,   63,   64,
 /*   750 */    65,   66,   67,   68,   69,   70,   71,   72,   73,  215,
 /*   760 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   770 */    42,   43,  227,  148,  201,  183,  183,  227,  202,  203,
 /*   780 */   236,  227,  239,  189,  189,  148,  189,   16,  148,  148,
 /*   790 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   800 */    72,   73,  148,   75,   76,   77,   78,   79,   80,   81,
 /*   810 */    82,   83,   84,   42,   43,  148,   20,  148,   22,  227,
 /*   820 */   227,  193,  192,  148,  170,  171,  189,  148,  200,  189,
 /*   830 */   242,  243,  125,  126,   63,   64,   65,   66,   67,   68,
 /*   840 */    69,   70,   71,   72,   73,  148,   75,   76,   77,   78,
 /*   850 */    79,   80,   81,   82,   83,   84,   16,   17,  148,   19,
 /*   860 */   148,   25,  148,   23,  148,   29,  148,  170,  171,  148,
 /*   870 */    19,   31,   16,   17,  148,   19,  209,   41,  209,   23,
 /*   880 */   170,  171,  170,  171,  170,  171,   92,   31,   48,  214,
 /*   890 */   148,  170,  171,  214,  162,  148,  170,  171,  104,   59,
 /*   900 */   148,  148,  148,   27,   48,  189,   22,  189,  148,  148,
 /*   910 */    34,  148,    7,    8,  148,   59,  148,  170,  171,   79,
 /*   920 */    80,  156,  170,  171,  170,  171,  156,   87,   88,   89,
 /*   930 */   170,  171,   92,  170,  171,   79,   80,   81,  170,  171,
 /*   940 */   148,  204,  189,   87,   88,   89,   16,   17,   92,   19,
 /*   950 */   148,  111,  148,   23,  148,  190,   20,  148,   22,  156,
 /*   960 */   190,   31,  170,  171,  113,  125,  126,  127,  128,  129,
 /*   970 */   130,   91,  170,  171,  170,  171,  170,  171,   48,  170,
 /*   980 */   171,  125,  126,  127,  128,  129,  130,  148,   16,   59,
 /*   990 */     5,  111,  148,  190,   43,   10,   11,   12,   13,  156,
 /*  1000 */    20,  148,   22,  148,  124,  148,  122,  148,  148,   79,
 /*  1010 */    80,   26,   20,   28,  170,  171,  148,   87,   88,   89,
 /*  1020 */    35,  148,   92,  170,  171,  170,  171,  170,  171,  170,
 /*  1030 */   171,  148,   47,  190,   49,   91,   92,   51,   52,   54,
 /*  1040 */   148,  148,   57,  170,  171,  148,  179,   20,  148,   22,
 /*  1050 */    99,  148,   60,  170,  171,  125,  126,  127,  128,  129,
 /*  1060 */   130,  179,  170,  171,   92,  179,  148,  170,  171,   19,
 /*  1070 */   170,  171,  148,  170,  171,   20,  148,   22,   20,  148,
 /*  1080 */    22,  148,  148,  148,  232,  100,  101,  102,  170,  171,
 /*  1090 */    20,  106,   22,  148,  170,  171,  111,  148,  170,  171,
 /*  1100 */   148,  170,  171,  170,  171,  233,   20,   20,   22,   22,
 /*  1110 */    20,  148,   22,  148,  148,   20,  148,   22,  148,   69,
 /*  1120 */   135,  148,  148,  148,  148,  148,  148,  148,  173,  148,
 /*  1130 */   148,  192,  194,  150,  224,  229,  229,  173,  178,    6,
 /*  1140 */   173,  195,  173,  195,  173,  147,  147,  147,  147,   22,
 /*  1150 */   155,   99,   40,  122,   98,  119,  195,  120,  174,  172,
 /*  1160 */   172,  117,  172,  121,  131,  174,  172,  113,  153,  180,
 /*  1170 */   223,   97,   23,  161,  212,  153,   99,  116,   19,  161,
 /*  1180 */    15,  152,  175,  190,   38,  153,  172,  152,  172,  172,
 /*  1190 */   234,  153,  196,  180,  197,  175,  153,  152,  131,  153,
 /*  1200 */   198,  152,  199,   61,  153,   19,  185,   15,  185,   33,
 /*  1210 */   205,  138,  206,  205,  188,  206,  212,  153,  188,  153,
 /*  1220 */   195,  153,  212,  212,  153,  160,  185,  188,  188,  195,
 /*  1230 */     1,   20,   32,  176,   44,  176,   19,  113,  113,  113,
 /*  1240 */   216,  113,   19,   92,  216,   20,   20,  108,   11,   19,
 /*  1250 */    19,  115,   20,  118,  235,   22,   20,   22,  118,   19,
 /*  1260 */    22,   20,   20,  113,   44,   19,   44,   20,   19,   19,
 /*  1270 */    19,   96,  104,   16,   21,   17,   99,   22,  134,   36,
 /*  1280 */    99,   19,    5,    1,  237,  237,  103,   69,   69,   45,
 /*  1290 */    45,  231,  123,  240,   19,   14,  114,   17,  103,  114,
 /*  1300 */   116,  123,   19,  124,   20,  243,   14,  136,   19,  246,
 /*  1310 */    58,  137,    3,  247,    4,
};
#define YY_SHIFT_USE_DFLT (-106)
#define YY_SHIFT_MAX 386
static const short yy_shift_ofst[] = {
 /*     0 */    99,  840,  985,  -16,  840,  930,  930,  930,  274, -105,
 /*    10 */    96,  930,  930,  930,  930,  930,  -46,  250,  104,  540,
 /*    20 */   551,   76,   76,   53,  165,  208,  251,  323,  392,  461,
 /*    30 */   530,  599,  642,  685,  642,  642,  642,  642,  642,  642,
 /*    40 */   642,  642,  642,  642,  642,  642,  642,  642,  642,  642,
 /*    50 */   642,  728,  771,  771,  856,  930,  930,  930,  930,  930,
 /*    60 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    70 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    80 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    90 */   930,  930,  930,  -62,  -62,  -14,   27,   27,  -40,  219,
 /*   100 */   463,  560,  540,  540,  540,  540,  540,  540,  540,  551,
 /*   110 */   -72, -106, -106, -106,  130,  252,  468,  468,  192,  563,
 /*   120 */   150,  357,  540,  357,  540,  540,  540,  540,  540,  540,
 /*   130 */   540,  540,  540,  540,  540,  540,  540,  880,  214, -105,
 /*   140 */  -105, -105, -106, -106, -106,  249,  249,  320,  343,  411,
 /*   150 */   334,  477,  515,  542,  282,  529,  476,  538,  627,  540,
 /*   160 */   540,  578,  540,  540,  397,  540,  540,  404,  540,  540,
 /*   170 */   541,  404,  540,  540,  518,  518,  518,  540,  540,  541,
 /*   180 */   540,  540,  541,  540,  836,  587,  540,  540,  541,  540,
 /*   190 */   540,  540,  541,  540,  540,  540,  541,  541,  540,  540,
 /*   200 */   540,  540,  540,  540,  204,  876,  448,   91,  707,  707,
 /*   210 */   369,  876,  876,  951,  876,  876,  260,  884,  884, 1133,
 /*   220 */  1133, 1133, 1133, 1127, 1052, 1052, 1112, 1052, 1056, 1052,
 /*   230 */  -105, 1031, 1036, 1037, 1044, 1042, 1033, 1054, 1074, 1149,
 /*   240 */  1074, 1054, 1077, 1061, 1077, 1061, 1159, 1074, 1074, 1149,
 /*   250 */  1112, 1052, 1052, 1052, 1159, 1165, 1054, 1165, 1054, 1165,
 /*   260 */  1054, 1054, 1146, 1067, 1165, 1054, 1142, 1142, 1186, 1031,
 /*   270 */  1054, 1192, 1192, 1192, 1192, 1031, 1142, 1186, 1054, 1176,
 /*   280 */  1176, 1054, 1054, 1073, -106, -106, -106, -106, -106, -106,
 /*   290 */   317,  132,  629,  590,  794,  905,  851,  677,  972,  796,
 /*   300 */   936,  980,  944, 1027, 1055, 1058,  986, 1086, 1087, 1090,
 /*   310 */  1095, 1050, 1070,  992, 1229, 1211, 1200, 1190, 1217, 1124,
 /*   320 */  1125, 1126, 1128, 1223, 1225, 1226, 1151, 1139, 1230, 1237,
 /*   330 */  1231, 1232, 1233, 1236, 1135, 1235, 1140, 1238, 1136, 1240,
 /*   340 */  1241, 1150, 1242, 1220, 1246, 1247, 1249, 1250, 1222, 1251,
 /*   350 */  1175, 1168, 1257, 1258, 1253, 1177, 1243, 1244, 1255, 1245,
 /*   360 */  1144, 1181, 1262, 1277, 1282, 1183, 1218, 1219, 1169, 1275,
 /*   370 */  1182, 1281, 1184, 1280, 1185, 1195, 1178, 1283, 1179, 1284,
 /*   380 */  1292, 1252, 1171, 1174, 1289, 1309, 1310,
};
#define YY_REDUCE_USE_DFLT (-218)
#define YY_REDUCE_MAX 289
static const short yy_reduce_ofst[] = {
 /*     0 */   -56,  276,   -2,  -19,  399,  269,   49,  271,  270,   14,
 /*    10 */  -147,  -78,  273,  338,  340,  342,   44,  544,  263,  -60,
 /*    20 */    32,  144,  349, -217, -217, -217, -217, -217, -217, -217,
 /*    30 */  -217, -217, -217, -217, -217, -217, -217, -217, -217, -217,
 /*    40 */  -217, -217, -217, -217, -217, -217, -217, -217, -217, -217,
 /*    50 */  -217, -217, -217, -217,  405,  482,  485,  525,  568,  654,
 /*    60 */   697,  710,  712,  714,  721,  726,  747,  752,  754,  760,
 /*    70 */   763,  768,  792,  802,  804,  806,  809,  844,  853,  855,
 /*    80 */   857,  859,  873,  883,  892,  897,  900,  903,  918,  924,
 /*    90 */   928,  931,  933, -217, -217,  127, -217, -217, -217, -217,
 /*   100 */   454,  147,  509,  550,  554,  592,  593,  543,  489, -139,
 /*   110 */  -217, -217, -217, -217,   45,   21,   67,  120,  110,  110,
 /*   120 */     3,  389,  440,  573,  545,  594,  667,  675,  669,  595,
 /*   130 */   597,  637,  640,  716,  718,  679,  753,  293,  765,  770,
 /*   140 */   803,  843,  628,  576,  588, -112,  -83,   18,  154,  287,
 /*   150 */   302,  287,  287,   71,  339,  410,  423,  432,  494,  625,
 /*   160 */   641,  630,  432,  742,  732,  761,  766,  737,  839,  860,
 /*   170 */   287,  737,  868,  893,  867,  882,  886,  934,  935,  287,
 /*   180 */   945,  949,  287,  952,  852,  872,  963,  965,  287,  966,
 /*   190 */   968,  970,  287,  973,  974,  975,  287,  287,  976,  977,
 /*   200 */   978,  979,  981,  982,  983,  955,  939,  938,  906,  907,
 /*   210 */   910,  964,  967,  960,  969,  971,  984,  946,  948,  998,
 /*   220 */   999, 1000, 1001,  995,  987,  988,  989,  990,  991,  994,
 /*   230 */   993,  961,  996,  997, 1002, 1003,  947, 1015,  962, 1012,
 /*   240 */  1004, 1022, 1005, 1006, 1008, 1009, 1007, 1010, 1011, 1018,
 /*   250 */  1013, 1014, 1016, 1017, 1020, 1029, 1032, 1035, 1038, 1045,
 /*   260 */  1043, 1046,  956, 1019, 1049, 1051, 1021, 1023, 1024, 1025,
 /*   270 */  1064, 1026, 1030, 1039, 1040, 1034, 1041, 1028, 1066, 1047,
 /*   280 */  1048, 1068, 1071, 1053, 1065, 1057, 1059, 1060, 1062, 1063,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   592,  819,  896,  707,  896,  819,  896,  819,  896,  711,
 /*    10 */   870,  815,  819,  896,  896,  896,  790,  896,  841,  896,
 /*    20 */   623,  841,  841,  742,  896,  896,  896,  896,  896,  896,
 /*    30 */   896,  896,  743,  896,  818,  814,  810,  812,  811,  744,
 /*    40 */   731,  740,  747,  723,  855,  749,  750,  756,  757,  871,
 /*    50 */   874,  778,  796,  777,  896,  896,  896,  896,  896,  896,
 /*    60 */   896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
 /*    70 */   896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
 /*    80 */   896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
 /*    90 */   896,  896,  896,  780,  801,  616,  779,  789,  781,  782,
 /*   100 */   676,  611,  896,  896,  896,  896,  896,  896,  896,  896,
 /*   110 */   783,  784,  797,  798,  896,  896,  896,  896,  896,  896,
 /*   120 */   592,  707,  896,  707,  896,  896,  896,  896,  896,  896,
 /*   130 */   896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
 /*   140 */   896,  896,  701,  711,  889,  896,  896,  667,  896,  896,
 /*   150 */   896,  896,  896,  896,  896,  896,  896,  896,  599,  597,
 /*   160 */   896,  699,  896,  896,  625,  896,  896,  709,  896,  896,
 /*   170 */   714,  715,  896,  896,  896,  896,  896,  896,  896,  613,
 /*   180 */   896,  896,  688,  896,  847,  896,  896,  896,  862,  896,
 /*   190 */   896,  896,  860,  896,  896,  896,  690,  752,  829,  896,
 /*   200 */   896,  875,  877,  896,  896,  734,  699,  708,  896,  896,
 /*   210 */   813,  734,  734,  646,  734,  734,  649,  746,  746,  596,
 /*   220 */   596,  596,  596,  666,  678,  678,  663,  678,  649,  678,
 /*   230 */   896,  746,  737,  739,  727,  741,  896,  716,  735,  896,
 /*   240 */   735,  716,  724,  726,  724,  726,  823,  735,  735,  896,
 /*   250 */   663,  678,  678,  678,  823,  608,  716,  608,  716,  608,
 /*   260 */   716,  716,  851,  854,  608,  716,  680,  680,  758,  746,
 /*   270 */   716,  687,  687,  687,  687,  746,  680,  758,  716,  873,
 /*   280 */   873,  716,  716,  882,  633,  651,  651,  857,  889,  894,
 /*   290 */   896,  896,  896,  896,  896,  896,  765,  896,  896,  896,
 /*   300 */   896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
 /*   310 */   896,  836,  896,  896,  896,  896,  896,  896,  896,  770,
 /*   320 */   766,  896,  767,  896,  896,  896,  896,  693,  896,  896,
 /*   330 */   896,  896,  896,  896,  896,  728,  896,  738,  896,  896,
 /*   340 */   896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
 /*   350 */   896,  896,  896,  896,  896,  896,  896,  849,  850,  896,
 /*   360 */   896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
 /*   370 */   896,  896,  896,  896,  896,  896,  896,  896,  896,  896,
 /*   380 */   896,  881,  896,  896,  884,  593,  896,  587,  590,  589,
 /*   390 */   591,  595,  598,  620,  621,  622,  600,  601,  602,  603,
 /*   400 */   604,  605,  606,  612,  614,  632,  634,  641,  679,  682,
 /*   410 */   683,  684,  865,  866,  867,  642,  661,  664,  665,  643,
 /*   420 */   650,  732,  733,  644,  697,  698,  762,  691,  692,  696,
 /*   430 */   764,  768,  769,  771,  772,  619,  626,  627,  630,  631,
 /*   440 */   837,  839,  838,  840,  629,  628,  773,  776,  785,  786,
 /*   450 */   788,  794,  800,  803,  787,  792,  793,  795,  799,  802,
 /*   460 */   694,  695,  806,  808,  809,  863,  864,  804,  816,  817,
 /*   470 */   717,  807,  791,  729,  618,  736,  730,  700,  710,  719,
 /*   480 */   720,  721,  722,  705,  706,  712,  725,  760,  761,  713,
 /*   490 */   702,  703,  704,  805,  763,  774,  775,  645,  652,  653,
 /*   500 */   654,  657,  658,  659,  660,  655,  656,  824,  825,  827,
 /*   510 */   826,  647,  648,  662,  635,  636,  637,  638,  770,  639,
 /*   520 */   640,  624,  617,  668,  671,  672,  673,  674,  675,  677,
 /*   530 */   669,  670,  615,  607,  609,  718,  843,  852,  853,  848,
 /*   540 */   844,  845,  846,  610,  820,  821,  681,  754,  755,  842,
 /*   550 */   856,  858,  759,  859,  861,  886,  685,  686,  689,  828,
 /*   560 */   868,  745,  748,  751,  753,  830,  831,  832,  833,  834,
 /*   570 */   835,  869,  872,  876,  878,  879,  880,  883,  885,  890,
 /*   580 */   891,  892,  895,  893,  594,  588,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*  STATEMENT => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "STATEMENT",     "TRIGGER",       "VACUUM",        "VIEW",        
  "VIRTUAL",       "REINDEX",       "RENAME",        "CTIME_KW",    
  "ANY",           "OR",            "AND",           "IS",          
  "BETWEEN",       "IN",            "ISNULL",        "NOTNULL",     
  "NE",            "EQ",            "GT",            "LE",          
  "LT",            "GE",            "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "COLLATE",       "AUTOINCR",      "ON",          
  "DELETE",        "UPDATE",        "INSERT",        "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "UNION",       
  "ALL",           "EXCEPT",        "INTERSECT",     "SELECT",      
  "DISTINCT",      "DOT",           "FROM",          "JOIN",        
  "USING",         "ORDER",         "BY",            "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "REGISTER",      "VARIABLE",      "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "ALTER",       
  "TO",            "ADD",           "COLUMNKW",      "error",       
  "input",         "cmdlist",       "ecmd",          "cmdx",        
  "cmd",           "explain",       "transtype",     "trans_opt",   
  "nm",            "create_table",  "create_table_args",  "temp",        
  "ifnotexists",   "dbnm",          "columnlist",    "conslist_opt",
  "select",        "column",        "columnid",      "type",        
  "carglist",      "id",            "ids",           "typetoken",   
  "typename",      "signed",        "plus_num",      "minus_num",   
  "carg",          "ccons",         "term",          "expr",        
  "onconf",        "sortorder",     "autoinc",       "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "raisetype",   
  "ifexists",      "fullname",      "oneselect",     "multiselect_op",
  "distinct",      "selcollist",    "from",          "where_opt",   
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "sclp",          "as",            "seltablist",    "stl_prefix",  
  "joinop",        "on_opt",        "using_opt",     "seltablist_paren",
  "joinop2",       "inscollist",    "sortlist",      "sortitem",    
  "collate",       "exprlist",      "setlist",       "insert_cmd",  
  "inscollist_opt",  "itemlist",      "likeop",        "escape",      
  "between_op",    "in_op",         "case_operand",  "case_exprlist",
  "case_else",     "expritem",      "uniqueflag",    "idxitem",     
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",       "add_column_fullname",
  "kwcolumn_opt",  "create_vtab",   "vtabarglist",   "vtabarg",     
  "vtabargtoken",  "lp",            "anylist",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "carg ::= DEFAULT term",
 /*  51 */ "carg ::= DEFAULT LP expr RP",
 /*  52 */ "carg ::= DEFAULT PLUS term",
 /*  53 */ "carg ::= DEFAULT MINUS term",
 /*  54 */ "carg ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE id",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 144 */ "sortlist ::= sortitem collate sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "collate ::=",
 /* 150 */ "collate ::= COLLATE id",
 /* 151 */ "groupby_opt ::=",
 /* 152 */ "groupby_opt ::= GROUP BY exprlist",
 /* 153 */ "having_opt ::=",
 /* 154 */ "having_opt ::= HAVING expr",
 /* 155 */ "limit_opt ::=",
 /* 156 */ "limit_opt ::= LIMIT expr",
 /* 157 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 158 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 159 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 160 */ "where_opt ::=",
 /* 161 */ "where_opt ::= WHERE expr",
 /* 162 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 163 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 164 */ "setlist ::= nm EQ expr",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 166 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 167 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 168 */ "insert_cmd ::= INSERT orconf",
 /* 169 */ "insert_cmd ::= REPLACE",
 /* 170 */ "itemlist ::= itemlist COMMA expr",
 /* 171 */ "itemlist ::= expr",
 /* 172 */ "inscollist_opt ::=",
 /* 173 */ "inscollist_opt ::= LP inscollist RP",
 /* 174 */ "inscollist ::= inscollist COMMA nm",
 /* 175 */ "inscollist ::= nm",
 /* 176 */ "expr ::= term",
 /* 177 */ "expr ::= LP expr RP",
 /* 178 */ "term ::= NULL",
 /* 179 */ "expr ::= ID",
 /* 180 */ "expr ::= JOIN_KW",
 /* 181 */ "expr ::= nm DOT nm",
 /* 182 */ "expr ::= nm DOT nm DOT nm",
 /* 183 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 184 */ "term ::= STRING",
 /* 185 */ "expr ::= REGISTER",
 /* 186 */ "expr ::= VARIABLE",
 /* 187 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 188 */ "expr ::= ID LP distinct exprlist RP",
 /* 189 */ "expr ::= ID LP STAR RP",
 /* 190 */ "term ::= CTIME_KW",
 /* 191 */ "expr ::= expr AND expr",
 /* 192 */ "expr ::= expr OR expr",
 /* 193 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 194 */ "expr ::= expr EQ|NE expr",
 /* 195 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 196 */ "expr ::= expr PLUS|MINUS expr",
 /* 197 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 198 */ "expr ::= expr CONCAT expr",
 /* 199 */ "likeop ::= LIKE_KW",
 /* 200 */ "likeop ::= NOT LIKE_KW",
 /* 201 */ "likeop ::= MATCH",
 /* 202 */ "likeop ::= NOT MATCH",
 /* 203 */ "escape ::= ESCAPE expr",
 /* 204 */ "escape ::=",
 /* 205 */ "expr ::= expr likeop expr escape",
 /* 206 */ "expr ::= expr ISNULL|NOTNULL",
 /* 207 */ "expr ::= expr IS NULL",
 /* 208 */ "expr ::= expr NOT NULL",
 /* 209 */ "expr ::= expr IS NOT NULL",
 /* 210 */ "expr ::= NOT|BITNOT expr",
 /* 211 */ "expr ::= MINUS expr",
 /* 212 */ "expr ::= PLUS expr",
 /* 213 */ "between_op ::= BETWEEN",
 /* 214 */ "between_op ::= NOT BETWEEN",
 /* 215 */ "expr ::= expr between_op expr AND expr",
 /* 216 */ "in_op ::= IN",
 /* 217 */ "in_op ::= NOT IN",
 /* 218 */ "expr ::= expr in_op LP exprlist RP",
 /* 219 */ "expr ::= LP select RP",
 /* 220 */ "expr ::= expr in_op LP select RP",
 /* 221 */ "expr ::= expr in_op nm dbnm",
 /* 222 */ "expr ::= EXISTS LP select RP",
 /* 223 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 224 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 225 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 226 */ "case_else ::= ELSE expr",
 /* 227 */ "case_else ::=",
 /* 228 */ "case_operand ::= expr",
 /* 229 */ "case_operand ::=",
 /* 230 */ "exprlist ::= exprlist COMMA expritem",
 /* 231 */ "exprlist ::= expritem",
 /* 232 */ "expritem ::= expr",
 /* 233 */ "expritem ::=",
 /* 234 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 235 */ "uniqueflag ::= UNIQUE",
 /* 236 */ "uniqueflag ::=",
 /* 237 */ "idxlist_opt ::=",
 /* 238 */ "idxlist_opt ::= LP idxlist RP",
 /* 239 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 240 */ "idxlist ::= idxitem collate sortorder",
 /* 241 */ "idxitem ::= nm",
 /* 242 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 243 */ "cmd ::= VACUUM",
 /* 244 */ "cmd ::= VACUUM nm",
 /* 245 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 246 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 249 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 250 */ "cmd ::= PRAGMA nm dbnm",
 /* 251 */ "plus_num ::= plus_opt number",
 /* 252 */ "minus_num ::= MINUS number",
 /* 253 */ "number ::= INTEGER|FLOAT",
 /* 254 */ "plus_opt ::= PLUS",
 /* 255 */ "plus_opt ::=",
 /* 256 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 257 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 258 */ "trigger_time ::= BEFORE",
 /* 259 */ "trigger_time ::= AFTER",
 /* 260 */ "trigger_time ::= INSTEAD OF",
 /* 261 */ "trigger_time ::=",
 /* 262 */ "trigger_event ::= DELETE|INSERT",
 /* 263 */ "trigger_event ::= UPDATE",
 /* 264 */ "trigger_event ::= UPDATE OF inscollist",
 /* 265 */ "foreach_clause ::=",
 /* 266 */ "foreach_clause ::= FOR EACH ROW",
 /* 267 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 268 */ "when_clause ::=",
 /* 269 */ "when_clause ::= WHEN expr",
 /* 270 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 271 */ "trigger_cmd_list ::=",
 /* 272 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 273 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 274 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 275 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 276 */ "trigger_cmd ::= select",
 /* 277 */ "expr ::= RAISE LP IGNORE RP",
 /* 278 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 279 */ "raisetype ::= ROLLBACK",
 /* 280 */ "raisetype ::= ABORT",
 /* 281 */ "raisetype ::= FAIL",
 /* 282 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 283 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 284 */ "key_opt ::=",
 /* 285 */ "key_opt ::= KEY expr",
 /* 286 */ "database_kw_opt ::= DATABASE",
 /* 287 */ "database_kw_opt ::=",
 /* 288 */ "cmd ::= DETACH database_kw_opt expr",
 /* 289 */ "cmd ::= REINDEX",
 /* 290 */ "cmd ::= REINDEX nm dbnm",
 /* 291 */ "cmd ::= ANALYZE",
 /* 292 */ "cmd ::= ANALYZE nm dbnm",
 /* 293 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 294 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 295 */ "add_column_fullname ::= fullname",
 /* 296 */ "kwcolumn_opt ::=",
 /* 297 */ "kwcolumn_opt ::= COLUMNKW",
 /* 298 */ "cmd ::= create_vtab",
 /* 299 */ "cmd ::= create_vtab LP vtabarglist RP",
 /* 300 */ "create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm",
 /* 301 */ "vtabarglist ::= vtabarg",
 /* 302 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 303 */ "vtabarg ::=",
 /* 304 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 305 */ "vtabargtoken ::= ANY",
 /* 306 */ "vtabargtoken ::= lp anylist RP",
 /* 307 */ "lp ::= LP",
 /* 308 */ "anylist ::=",
 /* 309 */ "anylist ::= anylist ANY",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 156:
    case 190:
    case 207:
#line 374 "parse.y"
{sqlite3SelectDelete((yypminor->yy219));}
#line 1249 "parse.c"
      break;
    case 170:
    case 171:
    case 195:
    case 197:
    case 205:
    case 211:
    case 219:
    case 222:
    case 224:
    case 225:
    case 235:
#line 633 "parse.y"
{sqlite3ExprDelete((yypminor->yy172));}
#line 1264 "parse.c"
      break;
    case 175:
    case 183:
    case 193:
    case 196:
    case 198:
    case 200:
    case 210:
    case 213:
    case 214:
    case 217:
    case 223:
#line 870 "parse.y"
{sqlite3ExprListDelete((yypminor->yy174));}
#line 1279 "parse.c"
      break;
    case 189:
    case 194:
    case 202:
    case 203:
#line 502 "parse.y"
{sqlite3SrcListDelete((yypminor->yy373));}
#line 1287 "parse.c"
      break;
    case 199:
#line 563 "parse.y"
{
  sqlite3ExprDelete((yypminor->yy234).pLimit);
  sqlite3ExprDelete((yypminor->yy234).pOffset);
}
#line 1295 "parse.c"
      break;
    case 206:
    case 209:
    case 216:
#line 519 "parse.y"
{sqlite3IdListDelete((yypminor->yy432));}
#line 1302 "parse.c"
      break;
    case 231:
    case 236:
#line 966 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy243));}
#line 1308 "parse.c"
      break;
    case 233:
#line 950 "parse.y"
{sqlite3IdListDelete((yypminor->yy370).b);}
#line 1313 "parse.c"
      break;
    case 238:
#line 1034 "parse.y"
{sqlite3ExprDelete((yypminor->yy386));}
#line 1318 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
#line 44 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1487 "parse.c"
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 140, 1 },
  { 141, 2 },
  { 141, 1 },
  { 143, 1 },
  { 142, 1 },
  { 142, 3 },
  { 145, 0 },
  { 145, 1 },
  { 145, 3 },
  { 144, 3 },
  { 147, 0 },
  { 147, 1 },
  { 147, 2 },
  { 146, 0 },
  { 146, 1 },
  { 146, 1 },
  { 146, 1 },
  { 144, 2 },
  { 144, 2 },
  { 144, 2 },
  { 144, 2 },
  { 149, 6 },
  { 152, 0 },
  { 152, 3 },
  { 151, 1 },
  { 151, 0 },
  { 150, 4 },
  { 150, 2 },
  { 154, 3 },
  { 154, 1 },
  { 157, 3 },
  { 158, 1 },
  { 161, 1 },
  { 162, 1 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 159, 0 },
  { 159, 1 },
  { 163, 1 },
  { 163, 4 },
  { 163, 6 },
  { 164, 1 },
  { 164, 2 },
  { 165, 1 },
  { 165, 1 },
  { 160, 2 },
  { 160, 0 },
  { 168, 3 },
  { 168, 1 },
  { 168, 2 },
  { 168, 4 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 2 },
  { 169, 4 },
  { 169, 4 },
  { 169, 1 },
  { 169, 2 },
  { 174, 0 },
  { 174, 1 },
  { 176, 0 },
  { 176, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 179, 2 },
  { 179, 2 },
  { 179, 1 },
  { 179, 1 },
  { 177, 3 },
  { 177, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 2 },
  { 155, 0 },
  { 155, 2 },
  { 181, 3 },
  { 181, 2 },
  { 181, 1 },
  { 182, 2 },
  { 182, 7 },
  { 182, 5 },
  { 182, 5 },
  { 182, 10 },
  { 184, 0 },
  { 184, 1 },
  { 172, 0 },
  { 172, 3 },
  { 185, 0 },
  { 185, 2 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 144, 4 },
  { 188, 2 },
  { 188, 0 },
  { 144, 8 },
  { 144, 4 },
  { 144, 1 },
  { 156, 1 },
  { 156, 3 },
  { 191, 1 },
  { 191, 2 },
  { 191, 1 },
  { 190, 9 },
  { 192, 1 },
  { 192, 1 },
  { 192, 0 },
  { 200, 2 },
  { 200, 0 },
  { 193, 3 },
  { 193, 2 },
  { 193, 4 },
  { 201, 2 },
  { 201, 1 },
  { 201, 0 },
  { 194, 0 },
  { 194, 2 },
  { 203, 2 },
  { 203, 0 },
  { 202, 6 },
  { 202, 7 },
  { 207, 1 },
  { 207, 1 },
  { 153, 0 },
  { 153, 2 },
  { 189, 2 },
  { 204, 1 },
  { 204, 2 },
  { 204, 3 },
  { 204, 4 },
  { 205, 2 },
  { 205, 0 },
  { 206, 4 },
  { 206, 0 },
  { 198, 0 },
  { 198, 3 },
  { 210, 5 },
  { 210, 3 },
  { 211, 1 },
  { 173, 1 },
  { 173, 1 },
  { 173, 0 },
  { 212, 0 },
  { 212, 2 },
  { 196, 0 },
  { 196, 3 },
  { 197, 0 },
  { 197, 2 },
  { 199, 0 },
  { 199, 2 },
  { 199, 4 },
  { 199, 4 },
  { 144, 4 },
  { 195, 0 },
  { 195, 2 },
  { 144, 6 },
  { 214, 5 },
  { 214, 3 },
  { 144, 8 },
  { 144, 5 },
  { 144, 6 },
  { 215, 2 },
  { 215, 1 },
  { 217, 3 },
  { 217, 1 },
  { 216, 0 },
  { 216, 3 },
  { 209, 3 },
  { 209, 1 },
  { 171, 1 },
  { 171, 3 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 5 },
  { 170, 1 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 6 },
  { 171, 5 },
  { 171, 4 },
  { 170, 1 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 218, 1 },
  { 218, 2 },
  { 218, 1 },
  { 218, 2 },
  { 219, 2 },
  { 219, 0 },
  { 171, 4 },
  { 171, 2 },
  { 171, 3 },
  { 171, 3 },
  { 171, 4 },
  { 171, 2 },
  { 171, 2 },
  { 171, 2 },
  { 220, 1 },
  { 220, 2 },
  { 171, 5 },
  { 221, 1 },
  { 221, 2 },
  { 171, 5 },
  { 171, 3 },
  { 171, 5 },
  { 171, 4 },
  { 171, 4 },
  { 171, 5 },
  { 223, 5 },
  { 223, 4 },
  { 224, 2 },
  { 224, 0 },
  { 222, 1 },
  { 222, 0 },
  { 213, 3 },
  { 213, 1 },
  { 225, 1 },
  { 225, 0 },
  { 144, 11 },
  { 226, 1 },
  { 226, 0 },
  { 175, 0 },
  { 175, 3 },
  { 183, 5 },
  { 183, 3 },
  { 227, 1 },
  { 144, 4 },
  { 144, 1 },
  { 144, 2 },
  { 144, 5 },
  { 144, 5 },
  { 144, 5 },
  { 144, 5 },
  { 144, 6 },
  { 144, 3 },
  { 166, 2 },
  { 167, 2 },
  { 229, 1 },
  { 228, 1 },
  { 228, 0 },
  { 144, 5 },
  { 230, 11 },
  { 232, 1 },
  { 232, 1 },
  { 232, 2 },
  { 232, 0 },
  { 233, 1 },
  { 233, 1 },
  { 233, 3 },
  { 234, 0 },
  { 234, 3 },
  { 234, 3 },
  { 235, 0 },
  { 235, 2 },
  { 231, 3 },
  { 231, 0 },
  { 236, 6 },
  { 236, 8 },
  { 236, 5 },
  { 236, 4 },
  { 236, 1 },
  { 171, 4 },
  { 171, 6 },
  { 187, 1 },
  { 187, 1 },
  { 187, 1 },
  { 144, 4 },
  { 144, 6 },
  { 238, 0 },
  { 238, 2 },
  { 237, 1 },
  { 237, 0 },
  { 144, 3 },
  { 144, 1 },
  { 144, 3 },
  { 144, 1 },
  { 144, 3 },
  { 144, 6 },
  { 144, 6 },
  { 239, 1 },
  { 240, 0 },
  { 240, 1 },
  { 144, 1 },
  { 144, 4 },
  { 241, 7 },
  { 242, 1 },
  { 242, 3 },
  { 243, 0 },
  { 243, 2 },
  { 244, 1 },
  { 244, 3 },
  { 245, 1 },
  { 246, 0 },
  { 246, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 100 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1875 "parse.c"
        break;
      case 6:
#line 103 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1880 "parse.c"
        break;
      case 7:
#line 105 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1885 "parse.c"
        break;
      case 8:
#line 106 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1890 "parse.c"
        break;
      case 9:
#line 112 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy46);}
#line 1895 "parse.c"
        break;
      case 13:
#line 117 "parse.y"
{yygotominor.yy46 = TK_DEFERRED;}
#line 1900 "parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 107:
      case 109:
#line 118 "parse.y"
{yygotominor.yy46 = yymsp[0].major;}
#line 1909 "parse.c"
        break;
      case 17:
      case 18:
#line 121 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1915 "parse.c"
        break;
      case 19:
#line 123 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1920 "parse.c"
        break;
      case 21:
#line 128 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,yymsp[-4].minor.yy46,0,0,yymsp[-2].minor.yy46);
}
#line 1927 "parse.c"
        break;
      case 22:
      case 25:
      case 63:
      case 77:
      case 79:
      case 90:
      case 101:
      case 112:
      case 113:
      case 213:
      case 216:
#line 132 "parse.y"
{yygotominor.yy46 = 0;}
#line 1942 "parse.c"
        break;
      case 23:
      case 24:
      case 64:
      case 78:
      case 100:
      case 111:
      case 214:
      case 217:
#line 133 "parse.y"
{yygotominor.yy46 = 1;}
#line 1954 "parse.c"
        break;
      case 26:
#line 139 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy0,0);
}
#line 1961 "parse.c"
        break;
      case 27:
#line 142 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy219);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 1969 "parse.c"
        break;
      case 30:
#line 154 "parse.y"
{
  yygotominor.yy410.z = yymsp[-2].minor.yy410.z;
  yygotominor.yy410.n = (pParse->sLastToken.z-yymsp[-2].minor.yy410.z) + pParse->sLastToken.n;
}
#line 1977 "parse.c"
        break;
      case 31:
#line 158 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy410);
  yygotominor.yy410 = yymsp[0].minor.yy410;
}
#line 1985 "parse.c"
        break;
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 253:
#line 168 "parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy0;}
#line 1995 "parse.c"
        break;
      case 38:
#line 228 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy410);}
#line 2000 "parse.c"
        break;
      case 39:
      case 42:
      case 119:
      case 120:
      case 131:
      case 150:
      case 241:
      case 251:
      case 252:
#line 229 "parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy410;}
#line 2013 "parse.c"
        break;
      case 40:
#line 230 "parse.y"
{
  yygotominor.yy410.z = yymsp[-3].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy410.z;
}
#line 2021 "parse.c"
        break;
      case 41:
#line 234 "parse.y"
{
  yygotominor.yy410.z = yymsp[-5].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy410.z;
}
#line 2029 "parse.c"
        break;
      case 43:
#line 240 "parse.y"
{yygotominor.yy410.z=yymsp[-1].minor.yy410.z; yygotominor.yy410.n=yymsp[0].minor.yy410.n+(yymsp[0].minor.yy410.z-yymsp[-1].minor.yy410.z);}
#line 2034 "parse.c"
        break;
      case 44:
#line 242 "parse.y"
{ yygotominor.yy46 = atoi((char*)yymsp[0].minor.yy410.z); }
#line 2039 "parse.c"
        break;
      case 45:
#line 243 "parse.y"
{ yygotominor.yy46 = -atoi((char*)yymsp[0].minor.yy410.z); }
#line 2044 "parse.c"
        break;
      case 50:
      case 52:
#line 252 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy172);}
#line 2050 "parse.c"
        break;
      case 51:
#line 253 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy172);}
#line 2055 "parse.c"
        break;
      case 53:
#line 255 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2063 "parse.c"
        break;
      case 54:
#line 259 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy410);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2071 "parse.c"
        break;
      case 56:
#line 268 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy46);}
#line 2076 "parse.c"
        break;
      case 57:
#line 270 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy46,yymsp[0].minor.yy46,yymsp[-2].minor.yy46);}
#line 2081 "parse.c"
        break;
      case 58:
#line 271 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy46,0,0,0,0);}
#line 2086 "parse.c"
        break;
      case 59:
#line 272 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy172);}
#line 2091 "parse.c"
        break;
      case 60:
#line 274 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy410,yymsp[-1].minor.yy174,yymsp[0].minor.yy46);}
#line 2096 "parse.c"
        break;
      case 61:
#line 275 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy46);}
#line 2101 "parse.c"
        break;
      case 62:
#line 276 "parse.y"
{sqlite3AddCollateType(pParse, (char*)yymsp[0].minor.yy410.z, yymsp[0].minor.yy410.n);}
#line 2106 "parse.c"
        break;
      case 65:
#line 289 "parse.y"
{ yygotominor.yy46 = OE_Restrict * 0x010101; }
#line 2111 "parse.c"
        break;
      case 66:
#line 290 "parse.y"
{ yygotominor.yy46 = (yymsp[-1].minor.yy46 & yymsp[0].minor.yy405.mask) | yymsp[0].minor.yy405.value; }
#line 2116 "parse.c"
        break;
      case 67:
#line 292 "parse.y"
{ yygotominor.yy405.value = 0;     yygotominor.yy405.mask = 0x000000; }
#line 2121 "parse.c"
        break;
      case 68:
#line 293 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46;     yygotominor.yy405.mask = 0x0000ff; }
#line 2126 "parse.c"
        break;
      case 69:
#line 294 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<8;  yygotominor.yy405.mask = 0x00ff00; }
#line 2131 "parse.c"
        break;
      case 70:
#line 295 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<16; yygotominor.yy405.mask = 0xff0000; }
#line 2136 "parse.c"
        break;
      case 71:
#line 297 "parse.y"
{ yygotominor.yy46 = OE_SetNull; }
#line 2141 "parse.c"
        break;
      case 72:
#line 298 "parse.y"
{ yygotominor.yy46 = OE_SetDflt; }
#line 2146 "parse.c"
        break;
      case 73:
#line 299 "parse.y"
{ yygotominor.yy46 = OE_Cascade; }
#line 2151 "parse.c"
        break;
      case 74:
#line 300 "parse.y"
{ yygotominor.yy46 = OE_Restrict; }
#line 2156 "parse.c"
        break;
      case 75:
      case 76:
      case 91:
      case 93:
      case 95:
      case 96:
      case 168:
#line 302 "parse.y"
{yygotominor.yy46 = yymsp[0].minor.yy46;}
#line 2167 "parse.c"
        break;
      case 80:
#line 312 "parse.y"
{yygotominor.yy410.n = 0; yygotominor.yy410.z = 0;}
#line 2172 "parse.c"
        break;
      case 81:
#line 313 "parse.y"
{yygotominor.yy410 = yymsp[-1].minor.yy0;}
#line 2177 "parse.c"
        break;
      case 86:
#line 319 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy174,yymsp[0].minor.yy46,yymsp[-2].minor.yy46,0);}
#line 2182 "parse.c"
        break;
      case 87:
#line 321 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy174,yymsp[0].minor.yy46,0,0,0,0);}
#line 2187 "parse.c"
        break;
      case 88:
#line 322 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy172);}
#line 2192 "parse.c"
        break;
      case 89:
#line 324 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy174, &yymsp[-3].minor.yy410, yymsp[-2].minor.yy174, yymsp[-1].minor.yy46);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy46);
}
#line 2200 "parse.c"
        break;
      case 92:
      case 94:
#line 338 "parse.y"
{yygotominor.yy46 = OE_Default;}
#line 2206 "parse.c"
        break;
      case 97:
#line 343 "parse.y"
{yygotominor.yy46 = OE_Ignore;}
#line 2211 "parse.c"
        break;
      case 98:
      case 169:
#line 344 "parse.y"
{yygotominor.yy46 = OE_Replace;}
#line 2217 "parse.c"
        break;
      case 99:
#line 348 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 0, yymsp[-1].minor.yy46);
}
#line 2224 "parse.c"
        break;
      case 102:
#line 358 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, yymsp[0].minor.yy219, yymsp[-6].minor.yy46, yymsp[-4].minor.yy46);
}
#line 2231 "parse.c"
        break;
      case 103:
#line 361 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 1, yymsp[-1].minor.yy46);
}
#line 2238 "parse.c"
        break;
      case 104:
#line 368 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy219, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 2246 "parse.c"
        break;
      case 105:
      case 128:
#line 378 "parse.y"
{yygotominor.yy219 = yymsp[0].minor.yy219;}
#line 2252 "parse.c"
        break;
      case 106:
#line 380 "parse.y"
{
  if( yymsp[0].minor.yy219 ){
    yymsp[0].minor.yy219->op = yymsp[-1].minor.yy46;
    yymsp[0].minor.yy219->pPrior = yymsp[-2].minor.yy219;
  }
  yygotominor.yy219 = yymsp[0].minor.yy219;
}
#line 2263 "parse.c"
        break;
      case 108:
#line 389 "parse.y"
{yygotominor.yy46 = TK_ALL;}
#line 2268 "parse.c"
        break;
      case 110:
#line 393 "parse.y"
{
  yygotominor.yy219 = sqlite3SelectNew(yymsp[-6].minor.yy174,yymsp[-5].minor.yy373,yymsp[-4].minor.yy172,yymsp[-3].minor.yy174,yymsp[-2].minor.yy172,yymsp[-1].minor.yy174,yymsp[-7].minor.yy46,yymsp[0].minor.yy234.pLimit,yymsp[0].minor.yy234.pOffset);
}
#line 2275 "parse.c"
        break;
      case 114:
      case 238:
#line 414 "parse.y"
{yygotominor.yy174 = yymsp[-1].minor.yy174;}
#line 2281 "parse.c"
        break;
      case 115:
      case 141:
      case 151:
      case 237:
#line 415 "parse.y"
{yygotominor.yy174 = 0;}
#line 2289 "parse.c"
        break;
      case 116:
#line 416 "parse.y"
{
   yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-2].minor.yy174,yymsp[-1].minor.yy172,yymsp[0].minor.yy410.n?&yymsp[0].minor.yy410:0);
}
#line 2296 "parse.c"
        break;
      case 117:
#line 419 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-1].minor.yy174, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2303 "parse.c"
        break;
      case 118:
#line 422 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-3].minor.yy174, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2312 "parse.c"
        break;
      case 121:
#line 434 "parse.y"
{yygotominor.yy410.n = 0;}
#line 2317 "parse.c"
        break;
      case 122:
#line 446 "parse.y"
{yygotominor.yy373 = sqliteMalloc(sizeof(*yygotominor.yy373));}
#line 2322 "parse.c"
        break;
      case 123:
#line 447 "parse.y"
{yygotominor.yy373 = yymsp[0].minor.yy373;}
#line 2327 "parse.c"
        break;
      case 124:
#line 452 "parse.y"
{
   yygotominor.yy373 = yymsp[-1].minor.yy373;
   if( yygotominor.yy373 && yygotominor.yy373->nSrc>0 ) yygotominor.yy373->a[yygotominor.yy373->nSrc-1].jointype = yymsp[0].minor.yy46;
}
#line 2335 "parse.c"
        break;
      case 125:
#line 456 "parse.y"
{yygotominor.yy373 = 0;}
#line 2340 "parse.c"
        break;
      case 126:
#line 457 "parse.y"
{
  yygotominor.yy373 = sqlite3SrcListAppend(yymsp[-5].minor.yy373,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410);
  if( yymsp[-2].minor.yy410.n ) sqlite3SrcListAddAlias(yygotominor.yy373,&yymsp[-2].minor.yy410);
  if( yymsp[-1].minor.yy172 ){
    if( yygotominor.yy373 && yygotominor.yy373->nSrc>1 ){ yygotominor.yy373->a[yygotominor.yy373->nSrc-2].pOn = yymsp[-1].minor.yy172; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy172); }
  }
  if( yymsp[0].minor.yy432 ){
    if( yygotominor.yy373 && yygotominor.yy373->nSrc>1 ){ yygotominor.yy373->a[yygotominor.yy373->nSrc-2].pUsing = yymsp[0].minor.yy432; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy432); }
  }
}
#line 2356 "parse.c"
        break;
      case 127:
#line 471 "parse.y"
{
    yygotominor.yy373 = sqlite3SrcListAppend(yymsp[-6].minor.yy373,0,0);
    if( yygotominor.yy373 && yygotominor.yy373->nSrc>0 ) yygotominor.yy373->a[yygotominor.yy373->nSrc-1].pSelect = yymsp[-4].minor.yy219;
    if( yymsp[-2].minor.yy410.n ) sqlite3SrcListAddAlias(yygotominor.yy373,&yymsp[-2].minor.yy410);
    if( yymsp[-1].minor.yy172 ){
      if( yygotominor.yy373 && yygotominor.yy373->nSrc>1 ){ yygotominor.yy373->a[yygotominor.yy373->nSrc-2].pOn = yymsp[-1].minor.yy172; }
      else { sqlite3ExprDelete(yymsp[-1].minor.yy172); }
    }
    if( yymsp[0].minor.yy432 ){
      if( yygotominor.yy373 && yygotominor.yy373->nSrc>1 ){ yygotominor.yy373->a[yygotominor.yy373->nSrc-2].pUsing = yymsp[0].minor.yy432; }
      else { sqlite3IdListDelete(yymsp[0].minor.yy432); }
    }
  }
#line 2373 "parse.c"
        break;
      case 129:
#line 492 "parse.y"
{
     yygotominor.yy219 = sqlite3SelectNew(0,yymsp[0].minor.yy373,0,0,0,0,0,0,0);
  }
#line 2380 "parse.c"
        break;
      case 130:
#line 498 "parse.y"
{yygotominor.yy410.z=0; yygotominor.yy410.n=0;}
#line 2385 "parse.c"
        break;
      case 132:
#line 503 "parse.y"
{yygotominor.yy373 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);}
#line 2390 "parse.c"
        break;
      case 133:
#line 507 "parse.y"
{ yygotominor.yy46 = JT_INNER; }
#line 2395 "parse.c"
        break;
      case 134:
#line 508 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2400 "parse.c"
        break;
      case 135:
#line 509 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy410,0); }
#line 2405 "parse.c"
        break;
      case 136:
#line 511 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy410,&yymsp[-1].minor.yy410); }
#line 2410 "parse.c"
        break;
      case 137:
      case 145:
      case 154:
      case 161:
      case 176:
      case 203:
      case 226:
      case 228:
      case 232:
#line 515 "parse.y"
{yygotominor.yy172 = yymsp[0].minor.yy172;}
#line 2423 "parse.c"
        break;
      case 138:
      case 153:
      case 160:
      case 204:
      case 227:
      case 229:
      case 233:
#line 516 "parse.y"
{yygotominor.yy172 = 0;}
#line 2434 "parse.c"
        break;
      case 139:
      case 173:
#line 520 "parse.y"
{yygotominor.yy432 = yymsp[-1].minor.yy432;}
#line 2440 "parse.c"
        break;
      case 140:
      case 172:
#line 521 "parse.y"
{yygotominor.yy432 = 0;}
#line 2446 "parse.c"
        break;
      case 142:
      case 152:
#line 532 "parse.y"
{yygotominor.yy174 = yymsp[0].minor.yy174;}
#line 2452 "parse.c"
        break;
      case 143:
#line 533 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174,yymsp[-2].minor.yy172,yymsp[-1].minor.yy410.n>0?&yymsp[-1].minor.yy410:0);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2460 "parse.c"
        break;
      case 144:
#line 537 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy172,yymsp[-1].minor.yy410.n>0?&yymsp[-1].minor.yy410:0);
  if( yygotominor.yy174 && yygotominor.yy174->a ) yygotominor.yy174->a[0].sortOrder = yymsp[0].minor.yy46;
}
#line 2468 "parse.c"
        break;
      case 146:
      case 148:
#line 546 "parse.y"
{yygotominor.yy46 = SQLITE_SO_ASC;}
#line 2474 "parse.c"
        break;
      case 147:
#line 547 "parse.y"
{yygotominor.yy46 = SQLITE_SO_DESC;}
#line 2479 "parse.c"
        break;
      case 149:
#line 549 "parse.y"
{yygotominor.yy410.z = 0; yygotominor.yy410.n = 0;}
#line 2484 "parse.c"
        break;
      case 155:
#line 567 "parse.y"
{yygotominor.yy234.pLimit = 0; yygotominor.yy234.pOffset = 0;}
#line 2489 "parse.c"
        break;
      case 156:
#line 568 "parse.y"
{yygotominor.yy234.pLimit = yymsp[0].minor.yy172; yygotominor.yy234.pOffset = 0;}
#line 2494 "parse.c"
        break;
      case 157:
#line 570 "parse.y"
{yygotominor.yy234.pLimit = yymsp[-2].minor.yy172; yygotominor.yy234.pOffset = yymsp[0].minor.yy172;}
#line 2499 "parse.c"
        break;
      case 158:
#line 572 "parse.y"
{yygotominor.yy234.pOffset = yymsp[-2].minor.yy172; yygotominor.yy234.pLimit = yymsp[0].minor.yy172;}
#line 2504 "parse.c"
        break;
      case 159:
#line 576 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy373,yymsp[0].minor.yy172);}
#line 2509 "parse.c"
        break;
      case 162:
#line 587 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy373,yymsp[-1].minor.yy174,yymsp[0].minor.yy172,yymsp[-4].minor.yy46);}
#line 2514 "parse.c"
        break;
      case 163:
#line 593 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2519 "parse.c"
        break;
      case 164:
#line 594 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2524 "parse.c"
        break;
      case 165:
#line 600 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy373, yymsp[-1].minor.yy174, 0, yymsp[-4].minor.yy432, yymsp[-7].minor.yy46);}
#line 2529 "parse.c"
        break;
      case 166:
#line 602 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy373, 0, yymsp[0].minor.yy219, yymsp[-1].minor.yy432, yymsp[-4].minor.yy46);}
#line 2534 "parse.c"
        break;
      case 167:
#line 604 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy373, 0, 0, yymsp[-2].minor.yy432, yymsp[-5].minor.yy46);}
#line 2539 "parse.c"
        break;
      case 170:
      case 230:
#line 614 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-2].minor.yy174,yymsp[0].minor.yy172,0);}
#line 2545 "parse.c"
        break;
      case 171:
      case 231:
#line 615 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[0].minor.yy172,0);}
#line 2551 "parse.c"
        break;
      case 174:
#line 624 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(yymsp[-2].minor.yy432,&yymsp[0].minor.yy410);}
#line 2556 "parse.c"
        break;
      case 175:
#line 625 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(0,&yymsp[0].minor.yy410);}
#line 2561 "parse.c"
        break;
      case 177:
#line 636 "parse.y"
{yygotominor.yy172 = yymsp[-1].minor.yy172; sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2566 "parse.c"
        break;
      case 178:
      case 183:
      case 184:
#line 637 "parse.y"
{yygotominor.yy172 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2573 "parse.c"
        break;
      case 179:
      case 180:
#line 638 "parse.y"
{yygotominor.yy172 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2579 "parse.c"
        break;
      case 181:
#line 640 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy410);
  yygotominor.yy172 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2588 "parse.c"
        break;
      case 182:
#line 645 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy410);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy410);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy172 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2599 "parse.c"
        break;
      case 185:
#line 654 "parse.y"
{yygotominor.yy172 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2604 "parse.c"
        break;
      case 186:
#line 655 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy172 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2613 "parse.c"
        break;
      case 187:
#line 661 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_CAST, yymsp[-3].minor.yy172, 0, &yymsp[-1].minor.yy410);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2621 "parse.c"
        break;
      case 188:
#line 666 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprFunction(yymsp[-1].minor.yy174, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy46 && yygotominor.yy172 ){
    yygotominor.yy172->flags |= EP_Distinct;
  }
}
#line 2632 "parse.c"
        break;
      case 189:
#line 673 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2640 "parse.c"
        break;
      case 190:
#line 677 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy172 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->op = TK_CONST_FUNC;  
    yygotominor.yy172->span = yymsp[0].minor.yy0;
  }
}
#line 2653 "parse.c"
        break;
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
      case 198:
#line 686 "parse.y"
{yygotominor.yy172 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy172, yymsp[0].minor.yy172, 0);}
#line 2665 "parse.c"
        break;
      case 199:
      case 201:
#line 696 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 0;}
#line 2671 "parse.c"
        break;
      case 200:
      case 202:
#line 697 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 1;}
#line 2677 "parse.c"
        break;
      case 205:
#line 704 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy172, 0);
  if( yymsp[0].minor.yy172 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy172, 0);
  }
  yygotominor.yy172 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy72.eOperator);
  if( yymsp[-2].minor.yy72.not ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy172->span, &yymsp[-1].minor.yy172->span);
  if( yygotominor.yy172 ) yygotominor.yy172->flags |= EP_InfixFunc;
}
#line 2693 "parse.c"
        break;
      case 206:
#line 717 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(yymsp[0].major, yymsp[-1].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2701 "parse.c"
        break;
      case 207:
#line 721 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2709 "parse.c"
        break;
      case 208:
#line 725 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2717 "parse.c"
        break;
      case 209:
#line 729 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2725 "parse.c"
        break;
      case 210:
#line 733 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2733 "parse.c"
        break;
      case 211:
#line 737 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2741 "parse.c"
        break;
      case 212:
#line 741 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2749 "parse.c"
        break;
      case 215:
#line 748 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy172, 0);
  yygotominor.yy172 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy172, 0, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy172->span);
}
#line 2765 "parse.c"
        break;
      case 218:
#line 764 "parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pList = yymsp[-1].minor.yy174;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy174);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2779 "parse.c"
        break;
      case 219:
#line 774 "parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2792 "parse.c"
        break;
      case 220:
#line 783 "parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2806 "parse.c"
        break;
      case 221:
#line 793 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,yymsp[0].minor.yy410.z?&yymsp[0].minor.yy410:&yymsp[-1].minor.yy410);
  }
#line 2821 "parse.c"
        break;
      case 222:
#line 804 "parse.y"
{
    Expr *p = yygotominor.yy172 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
  }
#line 2834 "parse.c"
        break;
      case 223:
#line 816 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = yymsp[-2].minor.yy174;
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy174);
  }
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2847 "parse.c"
        break;
      case 224:
#line 827 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2855 "parse.c"
        break;
      case 225:
#line 831 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2863 "parse.c"
        break;
      case 234:
#line 858 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy410, &yymsp[-5].minor.yy410, sqlite3SrcListAppend(0,&yymsp[-3].minor.yy410,0), yymsp[-1].minor.yy174, yymsp[-9].minor.yy46,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy46);
}
#line 2871 "parse.c"
        break;
      case 235:
      case 280:
#line 864 "parse.y"
{yygotominor.yy46 = OE_Abort;}
#line 2877 "parse.c"
        break;
      case 236:
#line 865 "parse.y"
{yygotominor.yy46 = OE_None;}
#line 2882 "parse.c"
        break;
      case 239:
#line 875 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy410.z, yymsp[-1].minor.yy410.n);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174, p, &yymsp[-2].minor.yy410);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2895 "parse.c"
        break;
      case 240:
#line 884 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy410.z, yymsp[-1].minor.yy410.n);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy410);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2908 "parse.c"
        break;
      case 242:
#line 898 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy373, yymsp[-1].minor.yy46);}
#line 2913 "parse.c"
        break;
      case 243:
      case 244:
#line 903 "parse.y"
{sqlite3Vacuum(pParse);}
#line 2919 "parse.c"
        break;
      case 245:
      case 247:
#line 910 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,0);}
#line 2925 "parse.c"
        break;
      case 246:
#line 911 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy0,0);}
#line 2930 "parse.c"
        break;
      case 248:
#line 913 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,1);
}
#line 2937 "parse.c"
        break;
      case 249:
#line 916 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410,&yymsp[-1].minor.yy410,0);}
#line 2942 "parse.c"
        break;
      case 250:
#line 917 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,0,0);}
#line 2947 "parse.c"
        break;
      case 256:
#line 929 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy410.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy410.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy243, &all);
}
#line 2957 "parse.c"
        break;
      case 257:
#line 938 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy410, &yymsp[-6].minor.yy410, yymsp[-5].minor.yy46, yymsp[-4].minor.yy370.a, yymsp[-4].minor.yy370.b, yymsp[-2].minor.yy373, yymsp[-1].minor.yy46, yymsp[0].minor.yy172, yymsp[-10].minor.yy46, yymsp[-8].minor.yy46);
  yygotominor.yy410 = (yymsp[-6].minor.yy410.n==0?yymsp[-7].minor.yy410:yymsp[-6].minor.yy410);
}
#line 2965 "parse.c"
        break;
      case 258:
      case 261:
#line 944 "parse.y"
{ yygotominor.yy46 = TK_BEFORE; }
#line 2971 "parse.c"
        break;
      case 259:
#line 945 "parse.y"
{ yygotominor.yy46 = TK_AFTER;  }
#line 2976 "parse.c"
        break;
      case 260:
#line 946 "parse.y"
{ yygotominor.yy46 = TK_INSTEAD;}
#line 2981 "parse.c"
        break;
      case 262:
      case 263:
#line 951 "parse.y"
{yygotominor.yy370.a = yymsp[0].major; yygotominor.yy370.b = 0;}
#line 2987 "parse.c"
        break;
      case 264:
#line 953 "parse.y"
{yygotominor.yy370.a = TK_UPDATE; yygotominor.yy370.b = yymsp[0].minor.yy432;}
#line 2992 "parse.c"
        break;
      case 265:
      case 266:
#line 956 "parse.y"
{ yygotominor.yy46 = TK_ROW; }
#line 2998 "parse.c"
        break;
      case 267:
#line 958 "parse.y"
{ yygotominor.yy46 = TK_STATEMENT; }
#line 3003 "parse.c"
        break;
      case 268:
#line 962 "parse.y"
{ yygotominor.yy172 = 0; }
#line 3008 "parse.c"
        break;
      case 269:
#line 963 "parse.y"
{ yygotominor.yy172 = yymsp[0].minor.yy172; }
#line 3013 "parse.c"
        break;
      case 270:
#line 967 "parse.y"
{
  if( yymsp[-2].minor.yy243 ){
    yymsp[-2].minor.yy243->pLast->pNext = yymsp[-1].minor.yy243;
  }else{
    yymsp[-2].minor.yy243 = yymsp[-1].minor.yy243;
  }
  yymsp[-2].minor.yy243->pLast = yymsp[-1].minor.yy243;
  yygotominor.yy243 = yymsp[-2].minor.yy243;
}
#line 3026 "parse.c"
        break;
      case 271:
#line 976 "parse.y"
{ yygotominor.yy243 = 0; }
#line 3031 "parse.c"
        break;
      case 272:
#line 982 "parse.y"
{ yygotominor.yy243 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy410, yymsp[-1].minor.yy174, yymsp[0].minor.yy172, yymsp[-4].minor.yy46); }
#line 3036 "parse.c"
        break;
      case 273:
#line 987 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy410, yymsp[-4].minor.yy432, yymsp[-1].minor.yy174, 0, yymsp[-7].minor.yy46);}
#line 3041 "parse.c"
        break;
      case 274:
#line 990 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy410, yymsp[-1].minor.yy432, 0, yymsp[0].minor.yy219, yymsp[-4].minor.yy46);}
#line 3046 "parse.c"
        break;
      case 275:
#line 994 "parse.y"
{yygotominor.yy243 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy410, yymsp[0].minor.yy172);}
#line 3051 "parse.c"
        break;
      case 276:
#line 997 "parse.y"
{yygotominor.yy243 = sqlite3TriggerSelectStep(yymsp[0].minor.yy219); }
#line 3056 "parse.c"
        break;
      case 277:
#line 1000 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy172 ){
    yygotominor.yy172->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3067 "parse.c"
        break;
      case 278:
#line 1007 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy410); 
  if( yygotominor.yy172 ) {
    yygotominor.yy172->iColumn = yymsp[-3].minor.yy46;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3078 "parse.c"
        break;
      case 279:
#line 1017 "parse.y"
{yygotominor.yy46 = OE_Rollback;}
#line 3083 "parse.c"
        break;
      case 281:
#line 1019 "parse.y"
{yygotominor.yy46 = OE_Fail;}
#line 3088 "parse.c"
        break;
      case 282:
#line 1024 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy373,yymsp[-1].minor.yy46);
}
#line 3095 "parse.c"
        break;
      case 283:
#line 1030 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, yymsp[0].minor.yy386);
}
#line 3102 "parse.c"
        break;
      case 284:
#line 1035 "parse.y"
{ yygotominor.yy386 = 0; }
#line 3107 "parse.c"
        break;
      case 285:
#line 1036 "parse.y"
{ yygotominor.yy386 = yymsp[0].minor.yy172; }
#line 3112 "parse.c"
        break;
      case 288:
#line 1042 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy172);
}
#line 3119 "parse.c"
        break;
      case 289:
#line 1048 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3124 "parse.c"
        break;
      case 290:
#line 1049 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3129 "parse.c"
        break;
      case 291:
#line 1054 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3134 "parse.c"
        break;
      case 292:
#line 1055 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3139 "parse.c"
        break;
      case 293:
#line 1060 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy373,&yymsp[0].minor.yy410);
}
#line 3146 "parse.c"
        break;
      case 294:
#line 1063 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy410);
}
#line 3153 "parse.c"
        break;
      case 295:
#line 1066 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy373);
}
#line 3160 "parse.c"
        break;
      case 298:
#line 1075 "parse.y"
{sqlite3VtabFinishParse(pParse,0);}
#line 3165 "parse.c"
        break;
      case 299:
#line 1076 "parse.y"
{sqlite3VtabFinishParse(pParse,&yymsp[0].minor.yy0);}
#line 3170 "parse.c"
        break;
      case 300:
#line 1077 "parse.y"
{
    sqlite3VtabBeginParse(pParse, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, &yymsp[0].minor.yy410);
}
#line 3177 "parse.c"
        break;
      case 303:
#line 1082 "parse.y"
{sqlite3VtabArgInit(pParse);}
#line 3182 "parse.c"
        break;
      case 305:
      case 306:
      case 307:
      case 309:
#line 1084 "parse.y"
{sqlite3VtabArgExtend(pParse,&yymsp[0].minor.yy0);}
#line 3190 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  if( !pParse->parseError ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
    pParse->parseError = 1;
  }
#line 3258 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    /* if( yymajor==0 ) return; // not sure why this was here... */
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
