% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WellSVM.R
\name{wellsvm_direct}
\alias{wellsvm_direct}
\title{wellsvm implements the wellsvm algorithm as shown in [1].}
\usage{
wellsvm_direct(x, y, testx, testy, C1 = 1, C2 = 0.1, gamma = 1)
}
\arguments{
\item{x}{A Nxd training data matrix, where N is the number of training instances and d is the dimension of instance;}

\item{y}{A Nx1 training label vector, where y = 1/-1 means positive/negative, and y = 0 means unlabeled;}

\item{testx}{A Mxd testing data matrix, where M is the number of testing instances;}

\item{testy}{A Mx1 testing label vector}

\item{C1}{A regularization parameter for labeled data, default 1;}

\item{C2}{A regularization parameter for unlabeled data, default 0.1;}

\item{gamma}{Gaussian kernel parameter, i.e., k(x,y) = exp(-gamma^2||x-y||^2/avg) where avg is the average distance among instances; when gamma = 0, linear kernel is used. default gamma = 1;}
}
\value{
prediction   - A Mx1 predicted testing label vector; accuracy     - The accuracy of prediction; cputime     - cpu running time;
}
\description{
wellsvm implements the wellsvm algorithm as shown in [1].
}
\references{
Y.-F. Li, I. W. Tsang, J. T. Kwok, and Z.-H. Zhou. Scalable and Convex Weakly Labeled SVMs. Journal of Machine Learning Research, 2013.

R.-E. Fan, P.-H. Chen, and C.-J. Lin. Working set selection using second order information for training SVM. Journal of Machine Learning Research 6, 1889-1918, 2005.
}

