% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{getChromeProfile}
\alias{getChromeProfile}
\title{Get Chrome profile.}
\usage{
getChromeProfile(dataDir, profileDir)
}
\arguments{
\item{dataDir}{Specifies the user data directory, which is where the browser will look for all of its state.}

\item{profileDir}{Selects directory of profile to associate with the first browser launched.}
}
\description{
\code{getChromeProfile}
A utility function to get a Chrome profile.
}
\section{Detail}{
 A chrome profile directory is passed as an extraCapability.
The data dir has a number of default locations
\describe{
\item{Windows XP}{
Google Chrome: C:/Documents and Settings/\%USERNAME\%/Local Settings/Application Data/Google/Chrome/User Data
}
\item{Windows 8 or 7 or Vista}{
Google Chrome: C:/Users/\%USERNAME\%/AppData/Local/Google/Chrome/User Data
}
\item{Mac OS X}{
Google Chrome: ~/Library/Application Support/Google/Chrome
}
\item{Linux}{
Google Chrome: ~/.config/google-chrome
}
}
The profile directory is contained in the user directory and by default is named "Default"
}
\examples{
\dontrun{
# example from windows using a profile directory "Profile 1"
cprof <- getChromeProfile("C:\\\\Users\\\\john\\\\AppData\\\\Local\\\\Google\\\\Chrome\\\\User Data", "Profile 1")
remDr <- remoteDriver(browserName = "chrome", extraCapabilities = cprof)
}
}

