% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSLI.R
\name{readSLI}
\alias{readSLI}
\title{Read ENVI spectral libraries}
\usage{
readSLI(path)
}
\arguments{
\item{path}{Path to spectral library file with ending .sli.}
}
\value{
The spectral libraries are read into a data.frame. The first column contains the wavelengths and the remaining columns contain the spectra.
}
\description{
read/write support for ENVI spectral libraries
}
\details{
ENVI spectral libraries consist of a binary data file (.sli) and a corresponding header (.hdr, or .sli.hdr) file.
}
\examples{

## Example data
sliFile <- system.file("external/vegSpec.sli", package="RStoolbox")
sliTmpFile <- paste0(tempdir(),"/vegetationSpectra.sli") 

## Read spectral library
sli <- readSLI(sliFile)
head(sli)
plot(sli[,1:2], col = "orange", type = "l")
lines(sli[,c(1,3)], col = "green")
 
## Write to binary spectral library
writeSLI(sli, path = sliTmpFile)
}
\seealso{
\code{\link{writeSLI}}
}

