% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_api_prj.R
\name{prj_start_package}
\alias{prj_start_package}
\title{Creates package structure inside the project.}
\usage{
prj_start_package(name, prj = NULL, skip_rc = FALSE, tmpl = "builtin")
}
\arguments{
\item{name}{name of the package to create. It must not contain special characters
like \\/\"\'<> otherwise package folder could not be created. It must not
contain _ also as it is requirement enforced on R package names. The folder
must not exist.
(type: character).}

\item{prj}{project object to create the package in. If not passed will init
project from working directory. (type: rsuite_project, default: NULL)}

\item{skip_rc}{if TRUE skip adding package under revision control.
(type: logical, default: FALSE)}

\item{tmpl}{name of the package template (or path to it) to use for package
structure  creation.
(type: character).}
}
\description{
Creates package structure inside the project.
}
\details{
It fails if the package exists already in the project.

Logs all messages from the building process onto the rsuite logger. Use \code{logging::setLevel}
to control logs verbosity. DEBUG level turns on building and downloading messages.

Package templates have to include the following files: DESCRIPTION, NAMESPACE, NEWS
}
\examples{
# create exemplary project base folder
prj_base <- tempfile("example_")
dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

# start project
prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

# start package in it
prj_start_package("mypackage", prj = prj, skip_rc = TRUE)

}
\seealso{
Other in project management: \code{\link{prj_build}},
  \code{\link{prj_clean_deps}}, \code{\link{prj_init}},
  \code{\link{prj_install_deps}}, \code{\link{prj_load}},
  \code{\link{prj_lock_env}}, \code{\link{prj_pack}},
  \code{\link{prj_start}}, \code{\link{prj_unload}},
  \code{\link{prj_zip}}
}
