% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/30_rc_adapter.R
\name{rc_adapter_create_base}
\alias{rc_adapter_create_base}
\title{Creates the base presentation for the RC adapter to use by concrete implementations.}
\usage{
rc_adapter_create_base(name)
}
\arguments{
\item{name}{name under which RC adapter will be registered in RSuite. It
cannot contain whitespaces or comma. (type: character)}
}
\value{
object of type rsuite_rc_adapter
}
\description{
Creates the base presentation for the RC adapter to use by concrete implementations.
}
\examples{
# create you own RC adapter
rc_adapter_create_own <- function() {
  result <- rc_adapter_create_base("Own")
  class(result) <- c("rc_adapter_own", class(result))
  return(result)
}

}
\seealso{
Other in extending RSuite with RC adapter: \code{\link{rc_adapter_get_version}},
  \code{\link{rc_adapter_is_under_control}},
  \code{\link{rc_adapter_pkg_struct_add}},
  \code{\link{rc_adapter_prj_struct_add}},
  \code{\link{rc_adapter_remove_admins}}
}
\concept{in extending RSuite with RC adapter}
