% Generated by roxygen2 (4.0.2): do not edit by hand
\name{n.tp}
\alias{n.tp}
\title{Sample size for true prevalence}
\usage{
n.tp(p, se, sp, precision, conf = 0.95)
}
\arguments{
\item{p}{estimated true prevalence (scalar or vector)}

\item{se}{test sensitivity (scalar or vector)}

\item{sp}{test specificity (scalar or vector)}

\item{precision}{absolute precision, +/- proportion equal to
half the width of the desired confidence interval (scalar or vector)}

\item{conf}{desired level of confidence for CI, default = 0.95 (scalar or vector)}
}
\value{
a vector of sample sizes
}
\description{
Calculates sample size for estimating true prevalence
using normal approximation
}
\examples{
# examples for n.tp
n.tp(0.1, 0.9, 0.99, 0.05)
n.tp(0.1, 0.9, 0.99, 0.05, conf = 0.99)
n.tp(c(0.05, 0.1, 0.2, 0.3, 0.4, 0.5), 0.9, 0.99, 0.05)
n.tp(0.5, 0.9, 0.99, c(0.01, 0.02, 0.05, 0.1, 0.2))
}
\keyword{methods}

