% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sep.exact}
\alias{sep.exact}
\title{Population sensitivity for census (all units tested)}
\usage{
sep.exact(d = 1, se = 1)
}
\arguments{
\item{d}{expected number of infected units in population (=design prevalence*N
rounded to next integer), scalar or vector of same length as se}

\item{se}{unit sensitivity of test (proportion), scalar or vector}
}
\value{
vector of population-level sensitivities
}
\description{
Calculates population sensitivity for detecting disease
  assuming imperfect test sensitivity, perfect test specificity
  and a census of all units in the population
}
\examples{
# examples for sep.exact - checked
sep.exact(d=1, se = 0.92)
inf<- 1:5
sens<- 0.8
sep.exact(d=inf, se=sens)
sep.exact(se=0.8, d = ceiling(0.01*c(10, 50, 100, 250, 500)))
}
\keyword{methods}

