% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sep.hypergeo}
\alias{sep.hypergeo}
\title{Hypergeometric Population sensitivity}
\usage{
sep.hypergeo(N, n, d, se = 1)
}
\arguments{
\item{N}{population size, scalar or vector of same length as n}

\item{n}{sample size (number tested), scalar or vector}

\item{d}{expected number of infected units in population (=design prevalence*N
rounded to next integer)}

\item{se}{unit sensitivity of test (proportion), scalar or vector of same length as n}
}
\value{
a vector of population-level sensitivities
}
\description{
Calculates population sensitivity for detecting disease,
  assuming imperfect test sensitivity, perfect test specificity
  and representative sampling,
  using hypergeometric approximation (assumes known population size)
}
\examples{
# examples for sep.hypergeo - checked
sep.hypergeo(N=100, n=50, d=1, se = 0.92)
inf<- 1:5
sens<- 0.8
sep.hypergeo(N=100, n=50, d=inf, se=sens)
N<- c(10, 50, 100, 250, 500)
sep.hypergeo(se=0.8, N=N, n=c(5, 25, 50, 125, 250), d = ceiling(0.01*N))
}
\keyword{methods}

